/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarCollectionManagerRequest<TGrpcRequest>
extends ProtostellarRequest<TGrpcRequest> {
    private final String bucketName;
    @Nullable
    private final String scopeName;
    @Nullable
    private final String collectionName;

    public ProtostellarCollectionManagerRequest(Core core, String bucketName, @Nullable String scopeName, @Nullable String collectionName, String requestName, RequestSpan span, Duration timeout, boolean idempotent, RetryStrategy retryStrategy, Map<String, Object> clientContext) {
        super(core, ServiceType.KV, requestName, span, timeout, idempotent, retryStrategy, clientContext);
        this.bucketName = Validators.notNull(bucketName, "Bucket name must not be null");
        this.scopeName = scopeName;
        this.collectionName = collectionName;
    }

    @Override
    protected Map<String, Object> serviceContext() {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", this.serviceType.ident());
        ctx.put("bucket", RedactableArgument.redactMeta(this.bucketName));
        if (this.scopeName != null) {
            ctx.put("scope", RedactableArgument.redactMeta(this.scopeName));
        }
        if (this.collectionName != null) {
            ctx.put("collection", RedactableArgument.redactMeta(this.collectionName));
        }
        return ctx;
    }
}

