/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.DefaultLoggerFormatter;
import com.couchbase.client.core.cnc.LoggerFormatter;
import com.couchbase.client.core.cnc.LoggingEventConsumer;
import com.couchbase.client.core.util.Validators;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class LoggerConfig {
    private final LoggingEventConsumer.Logger customLogger;
    private final boolean fallbackToConsole;
    private final boolean disableSlf4J;
    private final String loggerName;
    private final boolean diagnosticContextEnabled;
    private final Level consoleLogLevel;
    private final LoggerFormatter consoleLoggerFormatter;

    private LoggerConfig(Builder builder) {
        this.customLogger = builder.customLogger;
        this.disableSlf4J = builder.disableSlf4J;
        this.loggerName = builder.loggerName;
        this.fallbackToConsole = builder.fallbackToConsole;
        this.diagnosticContextEnabled = builder.diagnosticContextEnabled;
        this.consoleLogLevel = builder.consoleLogLevel;
        this.consoleLoggerFormatter = builder.consoleLoggerFormatter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LoggerConfig create() {
        return LoggerConfig.builder().build();
    }

    public static Builder fallbackToConsole(boolean fallbackToConsole) {
        return LoggerConfig.builder().fallbackToConsole(fallbackToConsole);
    }

    public static Builder disableSlf4J(boolean disableSlf4J) {
        return LoggerConfig.builder().disableSlf4J(disableSlf4J);
    }

    @Deprecated
    public static Builder loggerName(String loggerName) {
        return LoggerConfig.builder().loggerName(loggerName);
    }

    public static Builder enableDiagnosticContext(boolean diagnosticContextEnabled) {
        return LoggerConfig.builder().enableDiagnosticContext(diagnosticContextEnabled);
    }

    @Stability.Internal
    public static Builder customLogger(LoggingEventConsumer.Logger customLogger) {
        return LoggerConfig.builder().customLogger(customLogger);
    }

    public static Builder consoleLogLevel(Level consoleLogLevel) {
        return LoggerConfig.builder().consoleLogLevel(consoleLogLevel);
    }

    public Builder consoleLoggerFormatter(LoggerFormatter loggerFormatter) {
        return LoggerConfig.builder().consoleLoggerFormatter(loggerFormatter);
    }

    @Stability.Internal
    public LoggingEventConsumer.Logger customLogger() {
        return this.customLogger;
    }

    public boolean fallbackToConsole() {
        return this.fallbackToConsole;
    }

    public boolean disableSlf4J() {
        return this.disableSlf4J;
    }

    @Deprecated
    public String loggerName() {
        return this.loggerName;
    }

    public boolean diagnosticContextEnabled() {
        return this.diagnosticContextEnabled;
    }

    public Level consoleLogLevel() {
        return this.consoleLogLevel;
    }

    public LoggerFormatter consoleLoggerFormatter() {
        return this.consoleLoggerFormatter;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("customLogger", this.customLogger == null ? null : this.customLogger.getClass().getSimpleName());
        export.put("fallbackToConsole", this.fallbackToConsole);
        export.put("consoleLogLevel", this.consoleLogLevel);
        export.put("consoleLoggerFormatter", this.consoleLoggerFormatter == null ? null : this.consoleLoggerFormatter.getClass().getSimpleName());
        export.put("disableSlf4j", this.disableSlf4J);
        export.put("loggerName", this.loggerName);
        export.put("diagnosticContextEnabled", this.diagnosticContextEnabled);
        return export;
    }

    public static class Builder {
        private LoggingEventConsumer.Logger customLogger = null;
        private boolean fallbackToConsole = false;
        private boolean disableSlf4J = false;
        private String loggerName = "CouchbaseLogger";
        private boolean diagnosticContextEnabled = false;
        private Level consoleLogLevel = Defaults.DEFAULT_CONSOLE_LOG_LEVEL;
        private LoggerFormatter consoleLoggerFormatter = Defaults.DEFAULT_CONSOLE_LOGGER_FORMATTER;

        @Stability.Internal
        public Builder customLogger(LoggingEventConsumer.Logger customLogger) {
            this.customLogger = customLogger;
            return this;
        }

        public Builder fallbackToConsole(boolean fallbackToConsole) {
            this.fallbackToConsole = fallbackToConsole;
            return this;
        }

        public Builder disableSlf4J(boolean disableSlf4J) {
            this.disableSlf4J = disableSlf4J;
            return this;
        }

        @Deprecated
        public Builder loggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        public Builder enableDiagnosticContext(boolean diagnosticContextEnabled) {
            this.diagnosticContextEnabled = diagnosticContextEnabled;
            return this;
        }

        public Builder consoleLogLevel(Level consoleLogLevel) {
            this.consoleLogLevel = consoleLogLevel;
            return this;
        }

        public Builder consoleLoggerFormatter(LoggerFormatter loggerFormatter) {
            this.consoleLoggerFormatter = Validators.notNull(loggerFormatter, "LoggerFormatter");
            return this;
        }

        public LoggerConfig build() {
            return new LoggerConfig(this);
        }
    }

    @Stability.Internal
    public static class Defaults {
        public static final boolean DEFAULT_FALLBACK_TO_CONSOLE = false;
        public static final boolean DEFAULT_DISABLE_SLF4J = false;
        public static final String DEFAULT_LOGGER_NAME = "CouchbaseLogger";
        public static final boolean DEFAULT_DIAGNOSTIC_CONTEXT_ENABLED = false;
        public static final Level DEFAULT_CONSOLE_LOG_LEVEL = Level.INFO;
        public static final LoggerFormatter DEFAULT_CONSOLE_LOGGER_FORMATTER = DefaultLoggerFormatter.INSTANCE;
    }
}

