/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.AbstractMapPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.util.ConnectionString;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConnectionStringPropertyLoader
extends AbstractMapPropertyLoader<CoreEnvironment.Builder> {
    private final ConnectionString connectionString;
    private static final Map<String, String> COMPAT_ALIAS = new HashMap<String, String>();

    public ConnectionStringPropertyLoader(String connectionString) {
        this(ConnectionString.create(connectionString));
    }

    public ConnectionStringPropertyLoader(ConnectionString connectionString) {
        this.connectionString = Objects.requireNonNull(connectionString);
    }

    @Override
    protected Map<String, String> propertyMap() {
        Map<String, String> properties = this.connectionString.params().entrySet().stream().collect(Collectors.toMap(entry -> COMPAT_ALIAS.getOrDefault(entry.getKey(), (String)entry.getKey()), Map.Entry::getValue));
        if (this.connectionString.scheme() == ConnectionString.Scheme.COUCHBASES) {
            properties.put("security.enableTls", "true");
        }
        return properties;
    }

    static {
        COMPAT_ALIAS.put("certpath", "security.trustCertificate");
        COMPAT_ALIAS.put("enable_tls", "security.enableTls");
        COMPAT_ALIAS.put("kv_connect_timeout", "timeout.connectTimeout");
        COMPAT_ALIAS.put("kv_timeout", "timeout.kvTimeout");
        COMPAT_ALIAS.put("kv_durable_timeout", "timeout.kvDurableTimeout");
        COMPAT_ALIAS.put("view_timeout", "timeout.viewTimeout");
        COMPAT_ALIAS.put("query_timeout", "timeout.queryTimeout");
        COMPAT_ALIAS.put("analytics_timeout", "timeout.analyticsTimeout");
        COMPAT_ALIAS.put("search_timeout", "timeout.searchTimeout");
        COMPAT_ALIAS.put("management_timeout", "timeout.managementTimeout");
        COMPAT_ALIAS.put("enable_mutation_tokens", "io.enableMutationTokens");
        COMPAT_ALIAS.put("tcp_keepalive_time", "io.tcpKeepAliveTime");
        COMPAT_ALIAS.put("enable_tcp_keepalives", "io.enableTcpKeepAlives");
        COMPAT_ALIAS.put("config_poll_interval", "io.configPollInterval");
        COMPAT_ALIAS.put("config_idle_redial_timeout", "io.configIdleRedialTimeout");
        COMPAT_ALIAS.put("num_kv_connections", "io.numKvConnections");
        COMPAT_ALIAS.put("max_http_connections", "io.maxHttpConnections");
        COMPAT_ALIAS.put("idle_http_connection_timeout", "io.idleHttpConnectionTimeout");
    }
}

