/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.api.kv.CoreKvBinaryParamValidators;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.classic.ClassicHelper;
import com.couchbase.client.core.classic.kv.BinaryAccessor;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.AppendRequest;
import com.couchbase.client.core.msg.kv.DecrementRequest;
import com.couchbase.client.core.msg.kv.IncrementRequest;
import com.couchbase.client.core.msg.kv.PrependRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class ClassicCoreKvBinaryOps
implements CoreKvBinaryOps {
    private final Core core;
    private final CoreKeyspace keyspace;
    private final Duration defaultKvTimeout;
    private final Duration defaultKvDurableTimeout;

    public ClassicCoreKvBinaryOps(Core core, CoreKeyspace keyspace) {
        this.core = core;
        this.defaultKvTimeout = core.context().environment().timeoutConfig().kvTimeout();
        this.defaultKvDurableTimeout = core.context().environment().timeoutConfig().kvDurableTimeout();
        this.keyspace = keyspace;
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> appendAsync(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        AppendRequest request = this.appendRequestClassic(id, content, options, cas, durability);
        CompletableFuture<CoreMutationResult> future = BinaryAccessor.append(this.core, request, id, this.keyspace, durability);
        return ClassicHelper.newAsyncResponse(request, future);
    }

    private AppendRequest appendRequestClassic(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(this.core, id, this.keyspace, options, content, cas, durability);
        Duration timeout = this.timeout(options, durability);
        RetryStrategy retryStrategy = options.retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("append", options.parentSpan().orElse(null));
        AppendRequest request = new AppendRequest(timeout, this.context(), this.collectionIdentifier(), retryStrategy, id, content, cas, durability.levelIfSynchronous(), span);
        request.context().clientContext(options.clientContext());
        return request;
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> prependAsync(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        PrependRequest request = this.prependRequestClassic(id, content, options, cas, durability);
        CompletableFuture<CoreMutationResult> future = BinaryAccessor.prepend(this.core, request, id, this.keyspace, durability);
        return ClassicHelper.newAsyncResponse(request, future);
    }

    private PrependRequest prependRequestClassic(String id, byte[] content, CoreCommonOptions options, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(this.core, id, this.keyspace, options, content, cas, durability);
        Duration timeout = this.timeout(options, durability);
        RetryStrategy retryStrategy = options.retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("prepend", options.parentSpan().orElse(null));
        PrependRequest request = new PrependRequest(timeout, this.context(), this.collectionIdentifier(), retryStrategy, id, content, cas, durability.levelIfSynchronous(), span);
        request.context().clientContext(options.clientContext());
        return request;
    }

    @Override
    public CoreAsyncResponse<CoreCounterResult> incrementAsync(String id, CoreCommonOptions options, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        IncrementRequest request = this.incrementRequestClassic(id, options, expiry, delta, initial, durability);
        CompletableFuture<CoreCounterResult> future = BinaryAccessor.increment(this.core, request, id, this.keyspace, durability);
        return ClassicHelper.newAsyncResponse(request, future);
    }

    private IncrementRequest incrementRequestClassic(String id, CoreCommonOptions options, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateIncrementDecrementArgs(this.core, id, this.keyspace, options, expiry, delta, initial, durability);
        Duration timeout = this.timeout(options, durability);
        RetryStrategy retryStrategy = options.retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("increment", options.parentSpan().orElse(null));
        IncrementRequest request = new IncrementRequest(timeout, this.context(), this.collectionIdentifier(), retryStrategy, id, delta, initial, expiry, durability.levelIfSynchronous(), span);
        request.context().clientContext(options.clientContext());
        return request;
    }

    @Override
    public CoreAsyncResponse<CoreCounterResult> decrementAsync(String id, CoreCommonOptions options, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        Validators.notNull(options, "DecrementOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        DecrementRequest request = this.decrementRequestClassic(id, options, expiry, delta, initial, durability);
        CompletableFuture<CoreCounterResult> future = BinaryAccessor.decrement(this.core, request, id, this.keyspace, durability);
        return ClassicHelper.newAsyncResponse(request, future);
    }

    private DecrementRequest decrementRequestClassic(String id, CoreCommonOptions opts, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Duration timeout = this.timeout(opts, durability);
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment().retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("decrement", opts.parentSpan().orElse(null));
        DecrementRequest request = new DecrementRequest(timeout, this.context(), this.collectionIdentifier(), retryStrategy, id, delta, initial, expiry, durability.levelIfSynchronous(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    private CoreContext context() {
        return this.core.context();
    }

    private CoreEnvironment environment() {
        return this.core.context().environment();
    }

    private CollectionIdentifier collectionIdentifier() {
        return this.keyspace.toCollectionIdentifier();
    }

    private Duration timeout(CoreCommonOptions common, CoreDurability durability) {
        return common.timeout().orElse(durability.isPersistent() ? this.defaultKvDurableTimeout : this.defaultKvTimeout);
    }
}

