/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

@Stability.Internal
public class CoreKvParamValidators {
    private CoreKvParamValidators() {
    }

    public static void validateGetParams(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateInsertParams(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateUpsertParams(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry, boolean preserveExpiry) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateReplaceParams(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, long expiry, boolean preserveExpiry) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateRemoveParams(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateExistsParams(CoreCommonOptions common, String key) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateGetAndLockParams(CoreCommonOptions common, String key, Duration lockTime) {
        CoreKvParamValidators.validateCommonOptions(common, key);
        Validators.notNull(lockTime, "lockTime");
    }

    public static void validateGetAndTouchParams(CoreCommonOptions common, String key, long expiration) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateTouchParams(CoreCommonOptions common, String key, long expiry) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateUnlockParams(CoreCommonOptions common, String key, long cas, CollectionIdentifier collectionIdentifier) {
        CoreKvParamValidators.validateCommonOptions(common, key);
        if (cas == 0L) {
            throw new InvalidArgumentException("Unlock CAS must not be 0", null, ReducedKeyValueErrorContext.create(key, collectionIdentifier));
        }
    }

    public static void validateGetAllReplicasParams(CoreCommonOptions common, String key) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateGetAnyReplicaParams(CoreCommonOptions common, String key) {
        CoreKvParamValidators.validateCommonOptions(common, key);
    }

    public static void validateSubdocMutateParams(CoreCommonOptions common, String key, CoreStoreSemantics storeSemantics, long cas) {
        CoreKvParamValidators.validateCommonOptions(common, key);
        if (cas != 0L && storeSemantics != CoreStoreSemantics.REPLACE && storeSemantics != CoreStoreSemantics.REVIVE) {
            throw InvalidArgumentException.fromMessage("A non-zero CAS value requires \"replace\" store semantics.");
        }
    }

    private static void validateCommonOptions(CoreCommonOptions common, String key) {
        Validators.notNull(common, "Common Options");
        Validators.notNullOrEmpty(key, "Document ID");
    }
}

