/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.util.HashedWheelTimer;
import com.couchbase.client.core.deps.io.netty.util.Timeout;
import com.couchbase.client.core.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Stability.Internal
public class Timer {
    private static final Duration DEFAULT_TICK_DURATION = Duration.ofMillis(10L);
    private final HashedWheelTimer wheelTimer;
    private volatile boolean stopped = false;
    private final AtomicLong outstandingForRetry = new AtomicLong(0L);
    private final long maxNumRequestsInRetry;

    public static Timer create(long maxNumRequestsInRetry) {
        return new Timer(maxNumRequestsInRetry);
    }

    public static Timer createAndStart(long maxNumRequestsInRetry) {
        Timer timer = Timer.create(maxNumRequestsInRetry);
        timer.start();
        return timer;
    }

    private Timer(long maxNumRequestsInRetry) {
        this.maxNumRequestsInRetry = maxNumRequestsInRetry;
        this.wheelTimer = new HashedWheelTimer(new DefaultThreadFactory("cb-timer", true), DEFAULT_TICK_DURATION.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void scheduleForRetry(Core core, Request<? extends Response> request, Duration runAfter) {
        if (this.stopped) {
            request.cancel(CancellationReason.SHUTDOWN);
            return;
        }
        if (this.outstandingForRetry.get() >= this.maxNumRequestsInRetry) {
            request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY);
            return;
        }
        this.schedule(() -> {
            if (!request.completed()) {
                core.send(request, false);
            }
        }, runAfter);
    }

    public Timeout schedule(Runnable callback, Duration runAfter) {
        return this.schedule(callback, runAfter, false);
    }

    public Timeout schedule(Runnable callback, Duration runAfter, boolean respectMax) {
        if (this.stopped) {
            return null;
        }
        if (this.outstandingForRetry.incrementAndGet() >= this.maxNumRequestsInRetry && respectMax) {
            this.outstandingForRetry.getAndDecrement();
            return null;
        }
        return this.wheelTimer.newTimeout(timeout -> {
            this.outstandingForRetry.decrementAndGet();
            callback.run();
        }, runAfter.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void register(Request<Response> request) {
        if (this.stopped) {
            request.cancel(CancellationReason.SHUTDOWN);
            return;
        }
        Timeout registration = this.wheelTimer.newTimeout(timeout -> request.cancel(CancellationReason.TIMEOUT), request.timeout().toNanos(), TimeUnit.NANOSECONDS);
        request.timeoutRegistration(registration);
    }

    public void start() {
        this.wheelTimer.start();
    }

    public void stop() {
        this.stopped = true;
        this.wheelTimer.stop();
    }

    public long outstandingForRetry() {
        return this.outstandingForRetry.get();
    }

    public String toString() {
        return "Timer{wheelTimer=" + this.wheelTimer + ", stopped=" + this.stopped + ", outstandingForRetry=" + this.outstandingForRetry + ", maxNumRequestsInRetry=" + this.maxNumRequestsInRetry + '}';
    }
}

