/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import com.couchbase.client.core.endpoint.ProtostellarPool;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.util.Set;

@Stability.Internal
public class CoreProtostellar {
    public static final int DEFAULT_PROTOSTELLAR_TLS_PORT = 18098;
    private final ProtostellarPool pool;
    private final Set<SeedNode> seedNodes;
    private final Core core;

    public CoreProtostellar(Core core, Authenticator authenticator, Set<SeedNode> seedNodes) {
        if (core.context().environment().securityConfig().tlsEnabled() && !authenticator.supportsTls()) {
            throw new InvalidArgumentException("TLS enabled but the Authenticator does not support TLS!", null, null);
        }
        if (!core.context().environment().securityConfig().tlsEnabled() && !authenticator.supportsNonTls()) {
            throw new InvalidArgumentException("TLS not enabled but the Authenticator does only support TLS!", null, null);
        }
        if (seedNodes.isEmpty()) {
            throw new IllegalStateException("Have no seed nodes");
        }
        this.seedNodes = seedNodes;
        this.core = core;
        SeedNode first = (SeedNode)seedNodes.stream().findFirst().get();
        this.pool = new ProtostellarPool(core, first.address(), first.protostellarPort().orElse(18098));
    }

    public void shutdown(Duration timeout) {
        this.pool.shutdown(timeout);
    }

    public ProtostellarEndpoint endpoint() {
        return this.pool.endpoint();
    }

    public ProtostellarPool pool() {
        return this.pool;
    }
}

