/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.core.TooManyInstancesDetectedEvent;
import com.couchbase.client.core.error.TooManyInstancesException;

@Stability.Internal
public class CoreLimiter {
    private static int maxAllowedInstances = 1;
    private static int numInstances = 0;
    private static boolean failIfInstanceLimitReached = false;

    private CoreLimiter() {
    }

    public static synchronized void setMaxAllowedInstances(int maxAllowedInstances) {
        if (maxAllowedInstances < 1) {
            throw new IllegalArgumentException("maxAllowedInstances must be > 0, but was " + maxAllowedInstances);
        }
        CoreLimiter.maxAllowedInstances = maxAllowedInstances;
    }

    public static synchronized int getMaxAllowedInstances() {
        return maxAllowedInstances;
    }

    public static synchronized void setFailIfInstanceLimitReached(boolean failIfInstanceLimitReached) {
        CoreLimiter.failIfInstanceLimitReached = failIfInstanceLimitReached;
    }

    public static boolean getFailIfInstanceLimitReached() {
        return failIfInstanceLimitReached;
    }

    public static synchronized int numInstances() {
        return numInstances;
    }

    static synchronized void incrementAndVerifyNumInstances(EventBus eventBus) {
        if (numInstances >= maxAllowedInstances) {
            String msg = "The number of connected Cluster instances (" + (numInstances + 1) + ") exceeds the configured limit (" + maxAllowedInstances + "). It is recommended to create only one instance and reuse it across the application lifetime. Also, make sure to disconnect Clusters if they are not used anymore.";
            if (failIfInstanceLimitReached) {
                throw new TooManyInstancesException(msg);
            }
            eventBus.publish(new TooManyInstancesDetectedEvent(msg));
        }
        ++numInstances;
    }

    static synchronized void decrement() {
        --numInstances;
    }
}

