/*
 * Copyright 2023 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

@Stability.Internal
public class CoreIdGenerator {
  private static final long GLOBAL_ID = new SecureRandom().nextLong() << 32;

  private static final AtomicInteger counter = new AtomicInteger();

  private CoreIdGenerator() {
    throw new AssertionError("not instantiable");
  }

  /**
   * Returns an ID to assigned to a new core.
   * <p>
   * The high 32 bits are the same for every ID generated by this process.
   * The low 32 bits are a counter, incremented for each ID.
   */
  public static long nextId() {
    return GLOBAL_ID | (counter.incrementAndGet() & 0xffffffffL);
  }
}
