/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

public class HostAndPort {
    private final String hostname;
    private final int port;
    private final String stringified;

    public HostAndPort(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.stringified = RedactableArgument.redactSystem(hostname + ":" + port).toString();
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.port == that.port && Objects.equals(this.hostname, that.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port);
    }

    public String toString() {
        return this.stringified;
    }
}

