/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.KeyValueEndpoint;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.PooledService;
import com.couchbase.client.core.service.ServiceConfig;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategy.PartitionSelectionStrategy;
import java.util.Optional;

public class KeyValueService
extends PooledService {
    private static final EndpointSelectionStrategy STRATEGY = new PartitionSelectionStrategy();
    private final String hostname;
    private final int port;
    private final Optional<String> bucketname;
    private final Authenticator authenticator;

    public KeyValueService(ServiceConfig serviceConfig, CoreContext coreContext, String hostname, int port, Optional<String> bucketname, Authenticator authenticator) {
        super(serviceConfig, new ServiceContext(coreContext, hostname, port, ServiceType.KV, bucketname));
        this.hostname = hostname;
        this.port = port;
        this.bucketname = bucketname;
        this.authenticator = authenticator;
    }

    @Override
    protected Endpoint createEndpoint() {
        return new KeyValueEndpoint(this.serviceContext(), this.hostname, this.port, this.bucketname, this.authenticator);
    }

    @Override
    protected EndpointSelectionStrategy selectionStrategy() {
        return STRATEGY;
    }

    @Override
    public ServiceType type() {
        return ServiceType.KV;
    }
}

