/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.XattrInvalidKeyComboException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocMutateResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class SubdocMutateRequest
extends BaseKeyValueRequest<SubdocMutateResponse>
implements SyncDurabilityRequest {
    public static final String OPERATION_NAME = "subdoc_mutate";
    private static final byte SUBDOC_FLAG_XATTR_PATH = 4;
    private static final byte SUBDOC_FLAG_CREATE_PATH = 1;
    private static final byte SUBDOC_FLAG_EXPAND_MACRO = 16;
    private static final byte SUBDOC_DOC_FLAG_MKDOC = 1;
    private static final byte SUBDOC_DOC_FLAG_ADD = 2;
    public static final byte SUBDOC_DOC_FLAG_ACCESS_DELETED = 4;
    public static final byte SUBDOC_DOC_FLAG_CREATE_AS_DELETED = 8;
    public static final int SUBDOC_MAX_FIELDS = 16;
    private final byte flags;
    private final long expiration;
    private final long cas;
    private final List<Command> commands;
    private final String origKey;
    private final Optional<DurabilityLevel> syncReplicationType;

    public SubdocMutateRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, boolean insertDocument, boolean upsertDocument, boolean accessDeleted, boolean createAsDeleted, List<Command> commands, long expiration, long cas, Optional<DurabilityLevel> syncReplicationType, InternalSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        byte flags = 0;
        if (insertDocument && upsertDocument) {
            throw InvalidArgumentException.fromMessage("Cannot both insert and upsert full document");
        }
        if (upsertDocument) {
            flags = (byte)(flags | 1);
        }
        if (insertDocument) {
            flags = (byte)(flags | 2);
        }
        if (accessDeleted) {
            flags = (byte)(flags | 4);
        }
        if (createAsDeleted) {
            flags = (byte)(flags | 8);
        }
        this.flags = flags;
        this.commands = commands;
        this.expiration = expiration;
        this.cas = cas;
        this.origKey = key;
        this.syncReplicationType = syncReplicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        ByteBuf content = null;
        ByteBuf flexibleExtras = null;
        try {
            ByteBuf request;
            key = this.encodedKeyWithCollection(alloc, ctx);
            extras = alloc.buffer();
            if (this.expiration != 0L) {
                extras.writeInt((int)this.expiration);
            }
            if (this.flags != 0) {
                extras.writeByte(this.flags);
            }
            if (this.commands.size() == 1) {
                content = this.commands.get(0).encode(alloc);
            } else {
                content = alloc.compositeBuffer(this.commands.size());
                for (Command command : this.commands) {
                    ByteBuf commandBuffer = command.encode(alloc);
                    try {
                        ((CompositeByteBuf)content).addComponent(commandBuffer);
                        content.writerIndex(content.writerIndex() + commandBuffer.readableBytes());
                    }
                    catch (Exception ex) {
                        ReferenceCountUtil.release(commandBuffer);
                        throw ex;
                    }
                }
            }
            if (this.syncReplicationType.isPresent()) {
                if (!ctx.syncReplicationEnabled()) throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(this));
                flexibleExtras = MemcacheProtocol.flexibleSyncReplication(alloc, this.syncReplicationType.get(), this.timeout(), this.context());
                request = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.SUBDOC_MULTI_MUTATE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, flexibleExtras, extras, key, content);
            } else {
                request = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.SUBDOC_MULTI_MUTATE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, extras, key, content);
            }
            byteBuf = request;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            ReferenceCountUtil.release(flexibleExtras);
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        ReferenceCountUtil.release(flexibleExtras);
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public SubdocMutateResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        SubDocumentErrorContext e;
        Optional<ByteBuf> maybeBody = MemcacheProtocol.body(response);
        short rawOverallStatus = MemcacheProtocol.status(response);
        ResponseStatus overallStatus = MemcacheProtocol.decodeStatus(response);
        Optional<Object> error = Optional.empty();
        SubDocumentField[] values = null;
        if (maybeBody.isPresent()) {
            ByteBuf body = maybeBody.get();
            if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE.status() || rawOverallStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status()) {
                byte index = body.readByte();
                short opStatusRaw = body.readShort();
                SubDocumentOpResponseStatus opStatus = MemcacheProtocol.decodeSubDocumentStatus(opStatusRaw);
                Command c = this.commands.get(index);
                error = Optional.of(MemcacheProtocol.mapSubDocumentError(this, opStatus, c.path, c.originalIndex));
                values = new SubDocumentField[]{};
            } else if (overallStatus.success()) {
                values = new SubDocumentField[this.commands.size()];
                int INDEX_PLUS_STATUS_FIELDS_BYTES = 3;
                while (body.isReadable(INDEX_PLUS_STATUS_FIELDS_BYTES)) {
                    SubDocumentField op;
                    byte index = body.readByte();
                    Command command = this.commands.get(index);
                    short statusRaw = body.readShort();
                    SubDocumentOpResponseStatus status = MemcacheProtocol.decodeSubDocumentStatus(statusRaw);
                    if (status != SubDocumentOpResponseStatus.SUCCESS) {
                        SubDocumentField op2;
                        CouchbaseException err = MemcacheProtocol.mapSubDocumentError(this, status, command.path, command.originalIndex);
                        values[((Command)command).originalIndex] = op2 = new SubDocumentField(status, Optional.of(err), Bytes.EMPTY_BYTE_ARRAY, command.path, command.type);
                        continue;
                    }
                    int valueLength = body.readInt();
                    byte[] value = new byte[valueLength];
                    body.readBytes(value, 0, valueLength);
                    values[((Command)command).originalIndex] = op = new SubDocumentField(status, Optional.empty(), value, command.path, command.type);
                }
            }
        }
        if (values == null) {
            values = new SubDocumentField[]{};
        }
        if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_DOC_NOT_JSON.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_NOT_JSON);
            error = Optional.of(new DocumentNotJsonException(e));
        } else if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_DOC_TOO_DEEP.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_TOO_DEEP);
            error = Optional.of(new DocumentTooDeepException(e));
        } else if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.XATTR_INVALID_KEY_COMBO);
            error = Optional.of(new XattrInvalidKeyComboException(e));
        }
        return new SubdocMutateResponse(overallStatus, error, values, MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()));
    }

    private SubDocumentErrorContext createSubDocumentExceptionContext(SubDocumentOpResponseStatus status) {
        return new SubDocumentErrorContext(KeyValueErrorContext.completedRequest(this, ResponseStatus.SUBDOC_FAILURE), 0, null, status);
    }

    public static InvalidArgumentException errIfNoCommands(ErrorContext errorContext) {
        return new InvalidArgumentException("Argument validation failed", InvalidArgumentException.fromMessage("No SubDocument commands provided"), errorContext);
    }

    public static InvalidArgumentException errIfTooManyCommands(ErrorContext errorContext) {
        return new InvalidArgumentException("Argument validation failed", InvalidArgumentException.fromMessage("A maximum of 16 fields can be provided"), errorContext);
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }

    public static class Command {
        private final SubdocCommandType type;
        private final String path;
        private final byte[] fragment;
        private final boolean createParent;
        private final boolean xattr;
        private final boolean expandMacro;
        private final int originalIndex;

        public Command(SubdocCommandType type, String path, byte[] fragment, boolean createParent, boolean xattr, boolean expandMacro, int originalIndex) {
            this.type = type;
            this.path = path;
            this.xattr = xattr;
            this.fragment = fragment;
            this.createParent = createParent;
            this.expandMacro = expandMacro;
            this.originalIndex = originalIndex;
        }

        public ByteBuf encode(ByteBufAllocator alloc) {
            byte[] path = this.path.getBytes(StandardCharsets.UTF_8);
            int pathLength = path.length;
            ByteBuf buffer = alloc.buffer(4 + pathLength + this.fragment.length);
            buffer.writeByte(this.type.opcode());
            int flags = 0;
            if (this.xattr) {
                flags = (byte)(flags | 4);
            }
            if (this.createParent) {
                flags = (byte)(flags | 1);
            }
            if (this.expandMacro) {
                flags = (byte)(flags | 0x10);
            }
            buffer.writeByte(flags);
            buffer.writeShort(pathLength);
            buffer.writeInt(this.fragment.length);
            buffer.writeBytes(path);
            buffer.writeBytes(this.fragment);
            return buffer;
        }

        public int originalIndex() {
            return this.originalIndex;
        }

        public boolean xattr() {
            return this.xattr;
        }
    }
}

