/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.ObserveViaSeqnoResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class ObserveViaSeqnoRequest
extends BaseKeyValueRequest<ObserveViaSeqnoResponse> {
    public static final String OPERATION_NAME = "observe_seqno";
    private final int replica;
    private final boolean active;
    private final long vbucketUUID;

    public ObserveViaSeqnoRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, int replica, boolean active, long vbucketUUID, String key, InternalSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.replica = replica;
        this.active = active;
        this.vbucketUUID = vbucketUUID;
    }

    public int replica() {
        return this.replica;
    }

    public boolean active() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf body = null;
        try {
            body = alloc.buffer(8).writeLong(this.vbucketUUID);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.OBSERVE_SEQ, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), body);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(body);
            throw throwable;
        }
        ReferenceCountUtil.release(body);
        return byteBuf;
    }

    @Override
    public ObserveViaSeqnoResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        if (status.success()) {
            ByteBuf content = MemcacheProtocol.body(response).get();
            byte format = content.readByte();
            short vbucketId = content.readShort();
            long vbucketUUID = content.readLong();
            long lastPersistedSeqno = content.readLong();
            long currentSeqno = content.readLong();
            switch (format) {
                case 0: {
                    return new ObserveViaSeqnoResponse(status, this.active, vbucketId, vbucketUUID, lastPersistedSeqno, currentSeqno, Optional.empty(), Optional.empty());
                }
                case 1: {
                    return new ObserveViaSeqnoResponse(status, this.active, vbucketId, vbucketUUID, lastPersistedSeqno, currentSeqno, Optional.of(content.readLong()), Optional.of(content.readLong()));
                }
            }
            throw new IllegalStateException("Unsupported format 0x" + Integer.toHexString(format));
        }
        return new ObserveViaSeqnoResponse(status, this.active, 0, 0L, 0L, 0L, Optional.empty(), Optional.empty());
    }

    @Override
    public boolean idempotent() {
        return true;
    }
}

