/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.ObserveViaCasResponse;
import com.couchbase.client.core.msg.kv.ResponseStatusDetails;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class ObserveViaCasRequest
extends BaseKeyValueRequest<ObserveViaCasResponse> {
    private final int replica;
    private final boolean active;

    public ObserveViaCasRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, boolean active, int replica) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier);
        this.active = active;
        this.replica = replica;
    }

    public int replica() {
        return this.replica;
    }

    public boolean active() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf content = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            int keyLength = key.readableBytes();
            content = alloc.buffer(keyLength + 4);
            content.writeShort(this.partition());
            content.writeShort(keyLength);
            content.writeBytes(key);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.OBSERVE_CAS, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), content);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public ObserveViaCasResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        byte observed = ObserveViaCasResponse.ObserveStatus.UNKNOWN.value();
        long observedCas = 0L;
        ResponseStatusDetails statusDetails = null;
        if (status.success()) {
            ByteBuf content = MemcacheProtocol.body(response).get();
            short keyLength = content.getShort(2);
            observed = content.getByte(keyLength + 4);
            observedCas = content.getLong(keyLength + 5);
        } else {
            statusDetails = null;
        }
        return new ObserveViaCasResponse(status, observedCas, ObserveViaCasResponse.ObserveStatus.valueOf(observed), this.active, statusDetails);
    }

    @Override
    public boolean idempotent() {
        return true;
    }
}

