/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectWriter;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.MapperException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.nio.charset.StandardCharsets;

@Stability.Internal
public class Mapper {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader reader = mapper.reader();
    private static final ObjectWriter writer = mapper.writer();

    private Mapper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static byte[] encodeAsBytes(Object input) {
        try {
            return mapper.writeValueAsBytes(input);
        }
        catch (Exception ex) {
            throw new MapperException("Could not encode into JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static byte[] encodeAsBytesPretty(Object input) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(input);
        }
        catch (Exception ex) {
            throw new MapperException("Could not encode into JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static String encodeAsString(Object input) {
        try {
            return mapper.writeValueAsString(input);
        }
        catch (Exception ex) {
            throw new MapperException("Could not encode into JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static String encodeAsStringPretty(Object input) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(input);
        }
        catch (Exception ex) {
            throw new MapperException("Could not encode into JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static <T> T decodeInto(byte[] input, Class<T> clazz) {
        try {
            return mapper.readValue(input, clazz);
        }
        catch (Exception ex) {
            throw new MapperException("Could not decode from JSON: " + RedactableArgument.redactUser(new String(input, StandardCharsets.UTF_8)), ex);
        }
    }

    public static <T> T decodeInto(String input, Class<T> clazz) {
        try {
            return mapper.readValue(input, clazz);
        }
        catch (Exception ex) {
            throw new MapperException("Could not decode from JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static <T> T decodeInto(byte[] input, TypeReference<T> type) {
        try {
            return mapper.readValue(input, type);
        }
        catch (Exception ex) {
            throw new MapperException("Could not decode from JSON: " + RedactableArgument.redactUser(new String(input, StandardCharsets.UTF_8)), ex);
        }
    }

    public static <T> T decodeInto(String input, TypeReference<T> type) {
        try {
            return mapper.readValue(input, type);
        }
        catch (Exception ex) {
            throw new MapperException("Could not decode from JSON: " + RedactableArgument.redactUser(input), ex);
        }
    }

    public static JsonNode decodeIntoTree(byte[] input) {
        try {
            return mapper.readTree(input);
        }
        catch (Exception ex) {
            throw new MapperException("Could not decode from JSON: " + RedactableArgument.redactUser(new String(input, StandardCharsets.UTF_8)), ex);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return mapper.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return mapper.convertValue(fromValue, toValueTypeRef);
    }

    public static ObjectReader reader() {
        return reader;
    }

    public static ObjectWriter writer() {
        return writer;
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return mapper.createArrayNode();
    }
}

