/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.io.netty.kv.sasl.ScramSaslClientFactory;
import com.couchbase.client.core.util.Bytes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class ScramSaslClient
implements SaslClient {
    private static final byte[] CLIENT_KEY = "Client Key".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SERVER_KEY = "Server Key".getBytes(StandardCharsets.UTF_8);
    private final String name;
    private final String hmacAlgorithm;
    private final CallbackHandler callbacks;
    private final MessageDigest digest;
    private String clientNonce;
    private byte[] salt;
    private byte[] saltedPassword;
    private int iterationCount;
    private String clientFirstMessage;
    private String clientFirstMessageBare;
    private String clientFinalMessageNoProof;
    private String serverFirstMessage;
    private String serverFinalMessage;
    private String nonce;

    ScramSaslClient(ScramSaslClientFactory.Mode mode, CallbackHandler callbackHandler) throws NoSuchAlgorithmException {
        this.callbacks = callbackHandler;
        switch (mode) {
            case SCRAM_SHA512: {
                this.digest = MessageDigest.getInstance("SHA-512");
                this.name = ScramSaslClientFactory.Mode.SCRAM_SHA512.mech();
                this.hmacAlgorithm = "HmacSHA512";
                break;
            }
            case SCRAM_SHA256: {
                this.digest = MessageDigest.getInstance("SHA-256");
                this.name = ScramSaslClientFactory.Mode.SCRAM_SHA256.mech();
                this.hmacAlgorithm = "HmacSHA256";
                break;
            }
            case SCRAM_SHA1: {
                this.digest = MessageDigest.getInstance("SHA-1");
                this.name = ScramSaslClientFactory.Mode.SCRAM_SHA1.mech();
                this.hmacAlgorithm = "HmacSHA1";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported SHA version specified");
            }
        }
        SecureRandom random = new SecureRandom();
        byte[] random_nonce = new byte[21];
        random.nextBytes(random_nonce);
        this.clientNonce = Base64.getEncoder().encodeToString(random_nonce);
    }

    @Override
    public String getMechanismName() {
        return this.name;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.clientFirstMessage == null) {
            if (challenge.length != 0) {
                throw new SaslException("Initial challenge should be without input data");
            }
            this.clientFirstMessage = "n,,n=" + this.getUserName() + ",r=" + this.clientNonce;
            this.clientFirstMessageBare = this.clientFirstMessage.substring(3);
            return this.clientFirstMessage.getBytes(StandardCharsets.UTF_8);
        }
        if (this.serverFirstMessage == null) {
            this.serverFirstMessage = new String(challenge, StandardCharsets.UTF_8);
            HashMap<String, String> attributes = new HashMap<String, String>();
            try {
                ScramSaslClient.decodeAttributes(attributes, this.serverFirstMessage);
            }
            catch (Exception ex) {
                throw new SaslException("Could not decode attributes from server message \"" + this.serverFirstMessage + "\"", ex);
            }
            block9: for (Map.Entry<String, String> entry : attributes.entrySet()) {
                switch (entry.getKey().charAt(0)) {
                    case 'r': {
                        this.nonce = entry.getValue();
                        continue block9;
                    }
                    case 's': {
                        this.salt = Base64.getDecoder().decode(entry.getValue());
                        continue block9;
                    }
                    case 'i': {
                        this.iterationCount = Integer.parseInt(entry.getValue());
                        continue block9;
                    }
                }
                throw InvalidArgumentException.fromMessage("Invalid key supplied in the serverFirstMessage");
            }
            if (!(attributes.containsKey("r") && attributes.containsKey("s") && attributes.containsKey("i"))) {
                throw InvalidArgumentException.fromMessage("missing mandatory key in serverFirstMessage");
            }
            this.generateSaltedPassword();
            this.clientFinalMessageNoProof = "c=biws,r=" + this.nonce;
            String client_final_message = this.clientFinalMessageNoProof + ",p=" + Base64.getEncoder().encodeToString(this.getClientProof());
            return client_final_message.getBytes(StandardCharsets.UTF_8);
        }
        if (this.serverFinalMessage == null) {
            this.serverFinalMessage = new String(challenge, StandardCharsets.UTF_8);
            HashMap<String, String> attributes = new HashMap<String, String>();
            try {
                ScramSaslClient.decodeAttributes(attributes, this.serverFinalMessage);
            }
            catch (Exception ex) {
                throw new SaslException("Could not decode attributes from server message \"" + this.serverFinalMessage + "\"", ex);
            }
            if (attributes.containsKey("e")) {
                throw new SaslException("Authentication failure: " + attributes.get("e"));
            }
            if (!attributes.containsKey("v")) {
                throw new SaslException("Syntax error from the server");
            }
            String myServerSignature = Base64.getEncoder().encodeToString(this.getServerSignature());
            if (!myServerSignature.equals(attributes.get("v"))) {
                throw new SaslException("Server signature is incorrect");
            }
            return Bytes.EMPTY_BYTE_ARRAY;
        }
        throw new SaslException("Can't evaluate challenge on a session which is complete");
    }

    @Override
    public boolean isComplete() {
        return this.serverFinalMessage != null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        return Bytes.EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        return Bytes.EMPTY_BYTE_ARRAY;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() {
    }

    private String getUserName() throws SaslException {
        NameCallback nameCallback = new NameCallback("Username");
        try {
            this.callbacks.handle(new Callback[]{nameCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new SaslException("Missing callback fetch username", e);
        }
        String name = nameCallback.getName();
        if (name == null || name.isEmpty()) {
            throw new SaslException("Missing username");
        }
        return name;
    }

    private byte[] hmac(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance(this.hmacAlgorithm);
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException e) {
            if (key.length == 0) {
                throw new UnsupportedOperationException("This JVM does not support empty HMAC keys (empty passwords). Please set a bucket password or upgrade your JVM.");
            }
            throw new RuntimeException("Failed to generate HMAC hash for password", e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private byte[] pbkdf2(String password, byte[] salt, int iterations) {
        try {
            Mac mac = Mac.getInstance(this.hmacAlgorithm);
            SecretKey key = password == null || password.isEmpty() ? new EmptySecretKey(this.hmacAlgorithm) : new SecretKeySpec(password.getBytes(StandardCharsets.UTF_8), this.hmacAlgorithm);
            mac.init(key);
            mac.update(salt);
            mac.update("\u0000\u0000\u0000\u0001".getBytes(StandardCharsets.UTF_8));
            byte[] un = mac.doFinal();
            mac.update(un);
            byte[] uprev = mac.doFinal();
            ScramSaslClient.xor(un, uprev);
            for (int i = 2; i < iterations; ++i) {
                mac.update(uprev);
                uprev = mac.doFinal();
                ScramSaslClient.xor(un, uprev);
            }
            return un;
        }
        catch (InvalidKeyException e) {
            if (password == null || password.isEmpty()) {
                throw new UnsupportedOperationException("This JVM does not support empty HMAC keys (empty passwords). Please set a bucket password or upgrade your JVM.");
            }
            throw new RuntimeException("Failed to generate HMAC hash for password", e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void xor(byte[] result, byte[] other) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(result[i] ^ other[i]);
        }
    }

    private void generateSaltedPassword() throws SaslException {
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            this.callbacks.handle(new Callback[]{passwordCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new SaslException("Missing callback fetch password", e);
        }
        char[] pw = passwordCallback.getPassword();
        if (pw == null) {
            throw new SaslException("Password can't be null");
        }
        String password = new String(pw);
        this.saltedPassword = this.pbkdf2(password, this.salt, this.iterationCount);
        passwordCallback.clearPassword();
    }

    private byte[] getServerSignature() {
        byte[] serverKey = this.hmac(this.saltedPassword, SERVER_KEY);
        return this.hmac(serverKey, this.getAuthMessage().getBytes(StandardCharsets.UTF_8));
    }

    private byte[] getClientProof() {
        byte[] clientKey = this.hmac(this.saltedPassword, CLIENT_KEY);
        byte[] storedKey = this.digest.digest(clientKey);
        byte[] clientSignature = this.hmac(storedKey, this.getAuthMessage().getBytes(StandardCharsets.UTF_8));
        ScramSaslClient.xor(clientKey, clientSignature);
        return clientKey;
    }

    private static void decodeAttributes(HashMap<String, String> attributes, String string) {
        String[] tokens;
        for (String token : tokens = string.split(",")) {
            int idx = token.indexOf(61);
            if (idx != 1) {
                throw InvalidArgumentException.fromMessage("the input string is not according to the spec");
            }
            String key = token.substring(0, 1);
            if (attributes.containsKey(key)) {
                throw InvalidArgumentException.fromMessage("The key " + key + " is specified multiple times");
            }
            attributes.put(key, token.substring(2));
        }
    }

    private String getAuthMessage() {
        if (this.clientFirstMessageBare == null) {
            throw new RuntimeException("can't call getAuthMessage without clientFirstMessageBare is set");
        }
        if (this.serverFirstMessage == null) {
            throw new RuntimeException("can't call getAuthMessage without serverFirstMessage is set");
        }
        if (this.clientFinalMessageNoProof == null) {
            throw new RuntimeException("can't call getAuthMessage without clientFinalMessageNoProof is set");
        }
        return this.clientFirstMessageBare + "," + this.serverFirstMessage + "," + this.clientFinalMessageNoProof;
    }

    private static class EmptySecretKey
    implements SecretKey {
        private final String algorithm;

        public EmptySecretKey(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return Bytes.EMPTY_BYTE_ARRAY;
        }
    }
}

