/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.config.loader.BaseBucketLoader;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.msg.manager.BucketConfigRequest;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import reactor.core.publisher.Mono;

public class ClusterManagerBucketLoader
extends BaseBucketLoader {
    public ClusterManagerBucketLoader(Core core) {
        super(core, ServiceType.MANAGER);
    }

    @Override
    protected Mono<byte[]> discoverConfig(NodeIdentifier seed, String bucket) {
        CoreContext ctx = this.core().context();
        return Mono.defer(() -> {
            BucketConfigRequest request = new BucketConfigRequest(ctx.environment().timeoutConfig().connectTimeout(), ctx, BestEffortRetryStrategy.INSTANCE, bucket, ctx.authenticator(), seed);
            this.core().send(request);
            return Reactor.wrap(request, request.response(), true);
        }).map(response -> {
            if (response.status().success()) {
                return response.config();
            }
            throw new ConfigException("Received error status from ClusterManagerBucketLoader: " + response);
        });
    }
}

