/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.node.StandardMemcachedHashingStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MemcachedBucketConfig
extends AbstractBucketConfig {
    private final long rev;
    private final TreeMap<Long, NodeInfo> ketamaNodes;
    private final MemcachedHashingStrategy hashingStrategy;

    @JsonCreator
    public MemcachedBucketConfig(@JacksonInject(value="env") CoreEnvironment env, @JsonProperty(value="rev") long rev, @JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="bucketCapabilities") List<BucketCapabilities> bucketCapabilities, @JsonProperty(value="clusterCapabilities") Map<String, Set<ClusterCapabilities>> clusterCapabilities, @JacksonInject(value="origin") String origin) {
        super(uuid, name, BucketNodeLocator.KETAMA, uri, streamingUri, nodeInfos, portInfos, bucketCapabilities, origin, clusterCapabilities);
        this.rev = rev;
        this.ketamaNodes = new TreeMap();
        this.hashingStrategy = StandardMemcachedHashingStrategy.INSTANCE;
        this.populateKetamaNodes();
    }

    @Override
    public boolean tainted() {
        return false;
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.MEMCACHED;
    }

    public SortedMap<Long, NodeInfo> ketamaNodes() {
        return this.ketamaNodes;
    }

    private void populateKetamaNodes() {
        for (NodeInfo node : this.nodes()) {
            if (!node.services().containsKey((Object)ServiceType.KV)) continue;
            for (int i = 0; i < 40; ++i) {
                try {
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(this.hashingStrategy.hash(node, i).getBytes(StandardCharsets.UTF_8));
                    byte[] digest = md5.digest();
                    for (int j = 0; j < 4; ++j) {
                        Long key = (long)(digest[3 + j * 4] & 0xFF) << 24 | (long)(digest[2 + j * 4] & 0xFF) << 16 | (long)(digest[1 + j * 4] & 0xFF) << 8 | (long)(digest[j * 4] & 0xFF);
                        this.ketamaNodes.put(key, node);
                    }
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Could not populate ketama nodes.", e);
                }
            }
        }
    }

    public NodeIdentifier nodeForId(byte[] id) {
        long hash = MemcachedBucketConfig.calculateKetamaHash(id);
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, NodeInfo> tailMap = this.ketamaNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ketamaNodes.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        return this.ketamaNodes.get(hash).identifier();
    }

    @Override
    public boolean hasFastForwardMap() {
        return false;
    }

    private static long calculateKetamaHash(byte[] key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key);
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not encode ketama hash.", e);
        }
    }

    public String toString() {
        return "MemcachedBucketConfig{name='" + RedactableArgument.redactMeta(this.name()) + '\'' + ", rev=" + this.rev + ", nodes=" + RedactableArgument.redactSystem(new HashSet<NodeInfo>(this.ketamaNodes.values()).toString()) + ", hash=" + this.hashingStrategy + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemcachedBucketConfig that = (MemcachedBucketConfig)o;
        return this.rev == that.rev && Objects.equals(this.ketamaNodes, that.ketamaNodes) && Objects.equals(this.hashingStrategy, that.hashingStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.rev, this.ketamaNodes, this.hashingStrategy);
    }
}

