/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.config.BucketConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapDecodingFailedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshFailedEvent;
import com.couchbase.client.core.cnc.events.config.ConfigIgnoredEvent;
import com.couchbase.client.core.cnc.events.config.GlobalConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.IndividualGlobalConfigLoadFailedEvent;
import com.couchbase.client.core.cnc.events.config.SeedNodesUpdatedEvent;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketConfigParser;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.config.CollectionsManifestCollection;
import com.couchbase.client.core.config.CollectionsManifestScope;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.GlobalConfigParser;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.ProposedGlobalConfigContext;
import com.couchbase.client.core.config.loader.ClusterManagerBucketLoader;
import com.couchbase.client.core.config.loader.GlobalLoader;
import com.couchbase.client.core.config.loader.KeyValueBucketLoader;
import com.couchbase.client.core.config.refresher.ClusterManagerBucketRefresher;
import com.couchbase.client.core.config.refresher.GlobalRefresher;
import com.couchbase.client.core.config.refresher.KeyValueBucketRefresher;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.AlreadyShutdownException;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.CollectionMap;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetCollectionManifestRequest;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final int DEFAULT_KV_PORT = 11210;
    private static final int DEFAULT_MANAGER_PORT = 8091;
    private static final int DEFAULT_KV_TLS_PORT = 11207;
    private static final int DEFAULT_MANAGER_TLS_PORT = 18091;
    private static final int MAX_PARALLEL_LOADERS = 5;
    private final Core core;
    private final EventBus eventBus;
    private final KeyValueBucketLoader keyValueLoader;
    private final ClusterManagerBucketLoader clusterManagerLoader;
    private final KeyValueBucketRefresher keyValueRefresher;
    private final ClusterManagerBucketRefresher clusterManagerRefresher;
    private final GlobalLoader globalLoader;
    private final GlobalRefresher globalRefresher;
    private final ReplayProcessor<ClusterConfig> configs = ReplayProcessor.cacheLast();
    private final FluxSink<ClusterConfig> configsSink = this.configs.sink();
    private final ClusterConfig currentConfig = new ClusterConfig();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CollectionMap collectionMap = new CollectionMap();
    private final AtomicBoolean alternateAddrChecked = new AtomicBoolean(false);
    private volatile boolean globalConfigLoadInProgress = false;
    private volatile boolean bucketConfigLoadInProgress = false;
    private volatile boolean collectionMapRefreshInProgress = false;
    private final AtomicReference<Set<SeedNode>> currentSeedNodes;
    private final ReplayProcessor<Set<SeedNode>> seedNodes = ReplayProcessor.cacheLast();
    private final FluxSink<Set<SeedNode>> seedNodesSink = this.seedNodes.sink();

    public DefaultConfigurationProvider(Core core, Set<SeedNode> seedNodes) {
        this.core = core;
        this.eventBus = core.context().environment().eventBus();
        this.currentSeedNodes = new AtomicReference<Set<SeedNode>>(CbCollections.copyToUnmodifiableSet(seedNodes));
        this.keyValueLoader = new KeyValueBucketLoader(core);
        this.clusterManagerLoader = new ClusterManagerBucketLoader(core);
        this.keyValueRefresher = new KeyValueBucketRefresher(this, core);
        this.clusterManagerRefresher = new ClusterManagerBucketRefresher(this, core);
        this.globalLoader = new GlobalLoader(core);
        this.globalRefresher = new GlobalRefresher(this, core);
        this.configsSink.next((Object)this.currentConfig);
    }

    @Override
    public CollectionMap collectionMap() {
        return this.collectionMap;
    }

    @Override
    public Flux<ClusterConfig> configs() {
        return this.configs;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig;
    }

    @Override
    public Flux<Set<SeedNode>> seedNodes() {
        return this.seedNodes;
    }

    @Override
    public Mono<Void> openBucket(String name) {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.bucketConfigLoadInProgress = true;
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                int kvPort = tls ? 11207 : 11210;
                int managerPort = tls ? 18091 : 8091;
                Optional<String> alternate = this.core.context().alternateAddress();
                return Flux.fromIterable(this.currentSeedNodes()).take(5L).flatMap(seed -> {
                    int mappedManagerPort;
                    int mappedKvPort;
                    NodeIdentifier identifier = new NodeIdentifier(seed.address(), seed.clusterManagerPort().orElse(8091));
                    AtomicReference alternatePorts = new AtomicReference();
                    Optional<String> alternateAddress = alternate.map(a -> {
                        ClusterConfig c = this.currentConfig;
                        if (c.globalConfig() != null) {
                            for (PortInfo pi : c.globalConfig().portInfos()) {
                                if (!seed.address().equals(pi.hostname())) continue;
                                alternatePorts.set(tls ? pi.alternateAddresses().get(a).sslServices() : pi.alternateAddresses().get(a).services());
                                return pi.alternateAddresses().get(a).hostname();
                            }
                        }
                        List nodeInfos = c.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).collect(Collectors.toList());
                        for (NodeInfo ni : nodeInfos) {
                            if (!ni.hostname().equals(seed.address())) continue;
                            alternatePorts.set(tls ? ni.alternateAddresses().get(a).sslServices() : ni.alternateAddresses().get(a).services());
                            return ni.alternateAddresses().get(a).hostname();
                        }
                        return null;
                    });
                    if (alternateAddress.isPresent()) {
                        Map ports = (Map)alternatePorts.get();
                        mappedKvPort = (Integer)ports.get((Object)ServiceType.KV);
                        mappedManagerPort = (Integer)ports.get((Object)ServiceType.MANAGER);
                    } else {
                        mappedKvPort = seed.kvPort().orElse(kvPort);
                        mappedManagerPort = seed.clusterManagerPort().orElse(managerPort);
                    }
                    return this.keyValueLoader.load(identifier, mappedKvPort, name, alternateAddress).onErrorResume(t -> this.clusterManagerLoader.load(identifier, mappedManagerPort, name, alternateAddress));
                }).take(1L).switchIfEmpty((Publisher)Mono.error((Throwable)new ConfigException("Could not locate a single bucket configuration for bucket: " + name))).map(ctx -> {
                    this.proposeBucketConfig((ProposedBucketConfigContext)ctx);
                    return ctx;
                }).then(this.registerRefresher(name)).doOnTerminate(() -> {
                    this.bucketConfigLoadInProgress = false;
                }).onErrorResume(t -> this.closeBucketIgnoreShutdown(name).then(Mono.error((Throwable)t)));
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    @Override
    public Mono<Void> loadAndRefreshGlobalConfig() {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.globalConfigLoadInProgress = true;
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                int kvPort = tls ? 11207 : 11210;
                AtomicBoolean hasErrored = new AtomicBoolean();
                return Flux.fromIterable(this.currentSeedNodes()).take(5L).flatMap(seed -> {
                    NodeIdentifier identifier = new NodeIdentifier(seed.address(), seed.clusterManagerPort().orElse(8091));
                    long start = System.nanoTime();
                    return this.globalLoader.load(identifier, seed.kvPort().orElse(kvPort)).onErrorResume(throwable -> {
                        if (hasErrored.compareAndSet(false, true)) {
                            return Mono.error((Throwable)throwable);
                        }
                        this.core.context().environment().eventBus().publish(new IndividualGlobalConfigLoadFailedEvent(Duration.ofNanos(System.nanoTime() - start), this.core.context(), (Throwable)throwable, seed.address()));
                        return Mono.empty();
                    });
                }).take(1L).switchIfEmpty((Publisher)Mono.error((Throwable)new ConfigException("Could not locate a single global configuration"))).map(ctx -> {
                    this.proposeGlobalConfig((ProposedGlobalConfigContext)ctx);
                    return ctx;
                }).then(this.globalRefresher.start()).doOnTerminate(() -> {
                    this.globalConfigLoadInProgress = false;
                });
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    @Override
    public void proposeBucketConfig(ProposedBucketConfigContext ctx) {
        if (!this.shutdown.get()) {
            try {
                BucketConfig config = BucketConfigParser.parse(ctx.config(), this.core.context().environment(), ctx.origin());
                this.checkAndApplyConfig(config);
            }
            catch (Exception ex) {
                this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.PARSE_FAILURE, Optional.of(ex), Optional.of(ctx.config())));
            }
        } else {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.of(ctx.config())));
        }
    }

    @Override
    public void proposeGlobalConfig(ProposedGlobalConfigContext ctx) {
        if (!this.shutdown.get()) {
            try {
                GlobalConfig config = GlobalConfigParser.parse(ctx.config(), ctx.origin());
                this.checkAndApplyConfig(config);
            }
            catch (Exception ex) {
                this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.PARSE_FAILURE, Optional.of(ex), Optional.of(ctx.config())));
            }
        } else {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.of(ctx.config())));
        }
    }

    @Override
    public Mono<Void> closeBucket(String name) {
        return Mono.defer(() -> this.shutdown.get() ? Mono.error((Throwable)new AlreadyShutdownException()) : this.closeBucketIgnoreShutdown(name));
    }

    private Mono<Void> closeBucketIgnoreShutdown(String name) {
        return Mono.defer(() -> {
            this.currentConfig.deleteBucketConfig(name);
            this.pushConfig();
            return Mono.empty();
        }).then(this.keyValueRefresher.deregister(name)).then(this.clusterManagerRefresher.deregister(name));
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            if (this.shutdown.compareAndSet(false, true)) {
                return Flux.fromIterable(this.currentConfig.bucketConfigs().values()).flatMap(bucketConfig -> this.closeBucketIgnoreShutdown(bucketConfig.name())).then(Mono.defer(this::disableAndClearGlobalConfig)).doOnTerminate(() -> {
                    this.pushConfig();
                    this.configsSink.complete();
                }).then(this.keyValueRefresher.shutdown()).then(this.clusterManagerRefresher.shutdown()).then(this.globalRefresher.shutdown());
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    private Mono<Void> disableAndClearGlobalConfig() {
        return this.globalRefresher.stop().then(Mono.defer(() -> {
            this.currentConfig.deleteGlobalConfig();
            return Mono.empty();
        }));
    }

    @Override
    public void refreshCollectionMap(String bucket, boolean force) {
        if (!this.collectionMap.hasBucketMap(bucket) || force) {
            this.collectionMapRefreshInProgress = true;
            long start = System.nanoTime();
            GetCollectionManifestRequest request = new GetCollectionManifestRequest(this.core.context().environment().timeoutConfig().kvTimeout(), this.core.context(), (RetryStrategy)BestEffortRetryStrategy.INSTANCE, new CollectionIdentifier(bucket, Optional.empty(), Optional.empty()));
            this.core.send(request);
            request.response().whenComplete((response, throwable) -> {
                Duration duration = Duration.ofNanos(System.nanoTime() - start);
                if (throwable != null) {
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), (Throwable)throwable, CollectionMapRefreshFailedEvent.Reason.FAILED));
                    this.collectionMapRefreshInProgress = false;
                    return;
                }
                if (response.status().success() && response.manifest().isPresent()) {
                    this.parseAndStoreCollectionsManifest(bucket, response.manifest().get());
                } else if (response.status() == ResponseStatus.UNKNOWN) {
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), null, CollectionMapRefreshFailedEvent.Reason.NOT_SUPPORTED));
                } else {
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), new CouchbaseException(response.toString()), CollectionMapRefreshFailedEvent.Reason.UNKNOWN));
                }
                this.collectionMapRefreshInProgress = false;
            });
        }
    }

    @Override
    public boolean collectionMapRefreshInProgress() {
        return this.collectionMapRefreshInProgress;
    }

    private void parseAndStoreCollectionsManifest(String bucket, String raw) {
        try {
            CollectionsManifest manifest = (CollectionsManifest)Mapper.reader().forType(CollectionsManifest.class).readValue(raw);
            for (CollectionsManifestScope scope : manifest.scopes()) {
                for (CollectionsManifestCollection collection : scope.collections()) {
                    long parsed = Long.parseLong(collection.uid(), 16);
                    this.collectionMap.put(new CollectionIdentifier(bucket, Optional.of(scope.name()), Optional.of(collection.name())), UnsignedLEB128.encode(parsed));
                }
            }
        }
        catch (Exception ex) {
            this.eventBus.publish(new CollectionMapDecodingFailedEvent(this.core.context(), ex));
        }
    }

    private void checkAndApplyConfig(BucketConfig newConfig) {
        String name = newConfig.name();
        BucketConfig oldConfig = this.currentConfig.bucketConfig(name);
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty()));
            return;
        }
        if (newConfig.tainted()) {
            this.keyValueRefresher.markTainted(name);
            this.clusterManagerRefresher.markTainted(name);
        } else {
            this.keyValueRefresher.markUntainted(name);
            this.clusterManagerRefresher.markUntainted(name);
        }
        this.eventBus.publish(new BucketConfigUpdatedEvent(this.core.context(), newConfig));
        this.currentConfig.setBucketConfig(newConfig);
        this.checkAlternateAddress();
        this.updateSeedNodeList();
        this.pushConfig();
    }

    private void checkAndApplyConfig(GlobalConfig newConfig) {
        GlobalConfig oldConfig = this.currentConfig.globalConfig();
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty()));
            return;
        }
        this.eventBus.publish(new GlobalConfigUpdatedEvent(this.core.context(), newConfig));
        this.currentConfig.setGlobalConfig(newConfig);
        this.checkAlternateAddress();
        this.updateSeedNodeList();
        this.pushConfig();
    }

    private void updateSeedNodeList() {
        ClusterConfig config = this.currentConfig;
        boolean tlsEnabled = this.core.context().environment().securityConfig().tlsEnabled();
        if (config.globalConfig() != null) {
            Set<SeedNode> seedNodes = Collections.unmodifiableSet(config.globalConfig().portInfos().stream().map(ni -> {
                Map<ServiceType, Integer> ports;
                Map<ServiceType, Integer> map = ports = tlsEnabled ? ni.sslPorts() : ni.ports();
                if (!ports.containsKey((Object)ServiceType.KV)) {
                    return null;
                }
                return SeedNode.create(ni.hostname(), Optional.ofNullable(ports.get((Object)ServiceType.KV)), Optional.ofNullable(ports.get((Object)ServiceType.MANAGER)));
            }).filter(Objects::nonNull).collect(Collectors.toSet()));
            if (!seedNodes.isEmpty()) {
                this.eventBus.publish(new SeedNodesUpdatedEvent(this.core.context(), this.currentSeedNodes(), seedNodes));
                this.setSeedNodes(seedNodes);
            }
            return;
        }
        Set<SeedNode> seedNodes = Collections.unmodifiableSet(config.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).map(ni -> {
            Map<ServiceType, Integer> ports;
            Map<ServiceType, Integer> map = ports = tlsEnabled ? ni.sslServices() : ni.services();
            if (!ports.containsKey((Object)ServiceType.KV)) {
                return null;
            }
            return SeedNode.create(ni.hostname(), Optional.ofNullable(ports.get((Object)ServiceType.KV)), Optional.ofNullable(ports.get((Object)ServiceType.MANAGER)));
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (!seedNodes.isEmpty()) {
            this.eventBus.publish(new SeedNodesUpdatedEvent(this.core.context(), this.currentSeedNodes(), seedNodes));
            this.setSeedNodes(seedNodes);
        }
    }

    private synchronized void checkAlternateAddress() {
        if (this.alternateAddrChecked.compareAndSet(false, true)) {
            String resolved = DefaultConfigurationProvider.determineNetworkResolution(DefaultConfigurationProvider.extractAlternateAddressInfos(this.currentConfig), this.core.context().environment().ioConfig().networkResolution(), this.currentSeedNodes().stream().map(SeedNode::address).collect(Collectors.toSet()));
            this.core.context().alternateAddress(Optional.ofNullable(resolved));
        }
    }

    public static List<AlternateAddressHolder> extractAlternateAddressInfos(ClusterConfig config) {
        Stream<AlternateAddressHolder> holders = config.globalConfig() != null ? config.globalConfig().portInfos().stream().map(pi -> new AlternateAddressHolder(pi.hostname(), pi.alternateAddresses())) : config.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).map(ni -> new AlternateAddressHolder(ni.hostname(), ni.alternateAddresses()));
        return holders.collect(Collectors.toList());
    }

    public static String determineNetworkResolution(List<AlternateAddressHolder> nodes, NetworkResolution nr, Set<String> seedHosts) {
        if (nr.equals(NetworkResolution.DEFAULT)) {
            return null;
        }
        if (nr.equals(NetworkResolution.AUTO)) {
            for (AlternateAddressHolder info : nodes) {
                if (seedHosts.contains(info.hostname())) {
                    return null;
                }
                Map<String, AlternateAddress> aa = info.alternateAddresses();
                if (aa == null || aa.isEmpty()) continue;
                for (Map.Entry<String, AlternateAddress> entry : aa.entrySet()) {
                    AlternateAddress alternateAddress = entry.getValue();
                    if (alternateAddress == null || !seedHosts.contains(alternateAddress.hostname())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }
        return nr.name();
    }

    private void pushConfig() {
        this.configsSink.next((Object)this.currentConfig);
    }

    private Mono<Void> registerRefresher(String bucket) {
        return Mono.defer(() -> {
            BucketConfig config = this.currentConfig.bucketConfig(bucket);
            if (config == null) {
                return Mono.error((Throwable)new CouchbaseException("Bucket for registration does not exist, this is an error! Please report"));
            }
            if (config instanceof CouchbaseBucketConfig) {
                return this.keyValueRefresher.register(bucket);
            }
            return this.clusterManagerRefresher.register(bucket);
        });
    }

    @Override
    public boolean globalConfigLoadInProgress() {
        return this.globalConfigLoadInProgress;
    }

    @Override
    public boolean bucketConfigLoadInProgress() {
        return this.bucketConfigLoadInProgress;
    }

    Set<SeedNode> currentSeedNodes() {
        return this.currentSeedNodes.get();
    }

    private void setSeedNodes(Set<SeedNode> seedNodes) {
        this.currentSeedNodes.set(seedNodes);
        this.seedNodesSink.next(seedNodes);
    }

    public static class AlternateAddressHolder {
        private final String hostname;
        private final Map<String, AlternateAddress> alternateAddresses;

        AlternateAddressHolder(String hostname, Map<String, AlternateAddress> alternateAddresses) {
            this.hostname = hostname;
            this.alternateAddresses = alternateAddresses;
        }

        public String hostname() {
            return this.hostname;
        }

        public Map<String, AlternateAddress> alternateAddresses() {
            return this.alternateAddresses;
        }
    }
}

