/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.util.Validators;
import java.util.Map;
import java.util.Optional;

public class CoreContext
extends AbstractContext {
    private final long id;
    private final CoreEnvironment env;
    private final Core core;
    private final Authenticator authenticator;
    private volatile Optional<String> alternateAddress = Optional.empty();

    public CoreContext(Core core, long id, CoreEnvironment env, Authenticator authenticator) {
        this.id = id;
        this.env = env;
        this.core = core;
        this.authenticator = authenticator;
    }

    public long id() {
        return this.id;
    }

    public CoreEnvironment environment() {
        return this.env;
    }

    public Optional<String> alternateAddress() {
        return this.alternateAddress;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Stability.Internal
    public CoreContext alternateAddress(Optional<String> alternateAddress) {
        Validators.notNull(alternateAddress, "Alternate Address Identifier");
        this.alternateAddress = alternateAddress;
        return this;
    }

    public Core core() {
        return this.core;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        input.put("coreId", "0x" + Long.toHexString(this.id));
        this.alternateAddress.ifPresent(a -> input.put("alternateIdentifier", a));
    }
}

