/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class ScanPagedResult<T> {
    private final List<T> content;
    private final int totalElements;

    ScanPagedResult(List<T> content, int totalElements) {
        this.content = Collections.unmodifiableList(new ArrayList<T>(content));
        this.totalElements = totalElements;
    }

    List<T> getContent() {
        return this.content;
    }

    int getTotalElements() {
        return this.totalElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanPagedResult that = (ScanPagedResult)o;
        return this.totalElements == that.totalElements && this.content.equals(that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.totalElements);
    }

    public String toString() {
        return "ScanPagedResult{content=" + this.content + ", totalElements=" + this.totalElements + '}';
    }
}

