/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.ContrastSDK;
import com.contrastsecurity.sdk.scan.CodeArtifactClientImpl;
import com.contrastsecurity.sdk.scan.CodeArtifacts;
import com.contrastsecurity.sdk.scan.CodeArtifactsImpl;
import com.contrastsecurity.sdk.scan.ProjectClientImpl;
import com.contrastsecurity.sdk.scan.Projects;
import com.contrastsecurity.sdk.scan.ProjectsImpl;
import com.contrastsecurity.sdk.scan.ScanClientImpl;
import com.contrastsecurity.sdk.scan.ScanManager;
import com.contrastsecurity.sdk.scan.Scans;
import com.contrastsecurity.sdk.scan.ScansImpl;
import com.google.gson.Gson;
import java.util.Objects;

public final class ScanManagerImpl
implements ScanManager {
    private final CodeArtifacts.Factory codeArtifactsFactory;
    private final Scans.Factory scansFactory;
    private final Projects projects;

    public ScanManagerImpl(ContrastSDK contrast, Gson gson, String organizationId) {
        Objects.requireNonNull(contrast);
        Objects.requireNonNull(gson);
        Objects.requireNonNull(organizationId);
        CodeArtifactClientImpl codeArtifactClient = new CodeArtifactClientImpl(contrast, gson, organizationId);
        this.codeArtifactsFactory = new CodeArtifactsImpl.Factory(codeArtifactClient);
        ScanClientImpl scanClient = new ScanClientImpl(contrast, gson, organizationId);
        this.scansFactory = new ScansImpl.Factory(scanClient);
        ProjectClientImpl projectClient = new ProjectClientImpl(contrast, gson, organizationId);
        this.projects = new ProjectsImpl.Factory(this.codeArtifactsFactory, this.scansFactory, projectClient).create();
    }

    @Override
    public Projects projects() {
        return this.projects;
    }

    @Override
    public Scans scans(String projectId) {
        return this.scansFactory.create(projectId);
    }

    @Override
    public CodeArtifacts codeArtifacts(String projectId) {
        return this.codeArtifactsFactory.create(projectId);
    }
}

