/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.scan.CodeArtifacts;
import com.contrastsecurity.sdk.scan.Project;
import com.contrastsecurity.sdk.scan.ProjectClient;
import com.contrastsecurity.sdk.scan.ProjectImpl;
import com.contrastsecurity.sdk.scan.ProjectInner;
import com.contrastsecurity.sdk.scan.Projects;
import com.contrastsecurity.sdk.scan.Scans;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

final class ProjectsImpl
implements Projects {
    private final CodeArtifacts.Factory codeArtifactsFactory;
    private final Scans.Factory scansFactory;
    private final ProjectClient client;

    ProjectsImpl(CodeArtifacts.Factory codeArtifactsFactory, Scans.Factory scansFactory, ProjectClient client) {
        this.codeArtifactsFactory = Objects.requireNonNull(codeArtifactsFactory);
        this.scansFactory = Objects.requireNonNull(scansFactory);
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public Project.Definition define() {
        return new ProjectImpl.Definition(this.client, this.codeArtifactsFactory, this.scansFactory);
    }

    @Override
    public Optional<Project> findByName(String name) throws IOException {
        return this.client.findByName(name).map(inner -> new ProjectImpl(this.codeArtifactsFactory, this.scansFactory, (ProjectInner)inner));
    }

    static final class Factory
    implements Projects.Factory {
        private final CodeArtifacts.Factory codeArtifactsFactory;
        private final Scans.Factory scansFactory;
        private final ProjectClient client;

        Factory(CodeArtifacts.Factory codeArtifactsFactory, Scans.Factory scansFactory, ProjectClient client) {
            this.codeArtifactsFactory = Objects.requireNonNull(codeArtifactsFactory);
            this.scansFactory = Objects.requireNonNull(scansFactory);
            this.client = Objects.requireNonNull(client);
        }

        @Override
        public Projects create() {
            return new ProjectsImpl(this.codeArtifactsFactory, this.scansFactory, this.client);
        }
    }
}

