/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk;

import java.util.Objects;

public final class UserAgentProduct {
    private final String name;
    private final String version;
    private final String comment;

    public static UserAgentProduct of(String name) {
        return UserAgentProduct.of(name, null, null);
    }

    public static UserAgentProduct of(String name, String version) {
        return UserAgentProduct.of(name, version, null);
    }

    public static UserAgentProduct of(String name, String version, String comment) {
        return new UserAgentProduct(name, version, comment);
    }

    private UserAgentProduct(String name, String version, String comment) {
        this.name = Objects.requireNonNull(name);
        this.version = version;
        this.comment = comment;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String comment() {
        return this.comment;
    }

    public String toEncodedString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.version != null) {
            sb.append("/").append(this.version);
        }
        if (this.comment != null) {
            sb.append(" (").append(this.comment).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgentProduct that = (UserAgentProduct)o;
        return this.name.equals(that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.comment);
    }

    public String toString() {
        return this.toEncodedString();
    }
}

