/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk;

import com.contrastsecurity.exceptions.ApplicationCreateException;
import com.contrastsecurity.exceptions.HttpResponseException;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.ApplicationFilterForm;
import com.contrastsecurity.http.FilterForm;
import com.contrastsecurity.http.HttpMethod;
import com.contrastsecurity.http.JobOutcomePolicyListResponse;
import com.contrastsecurity.http.LibraryFilterForm;
import com.contrastsecurity.http.MediaType;
import com.contrastsecurity.http.SecurityCheckForm;
import com.contrastsecurity.http.SecurityCheckResponse;
import com.contrastsecurity.http.ServerFilterForm;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.http.TraceFilterKeycode;
import com.contrastsecurity.http.TraceFilterType;
import com.contrastsecurity.http.UrlBuilder;
import com.contrastsecurity.models.AgentType;
import com.contrastsecurity.models.Application;
import com.contrastsecurity.models.Applications;
import com.contrastsecurity.models.AssessLicenseOverview;
import com.contrastsecurity.models.Chapter;
import com.contrastsecurity.models.Coverage;
import com.contrastsecurity.models.EventDetails;
import com.contrastsecurity.models.EventResource;
import com.contrastsecurity.models.EventSummaryResponse;
import com.contrastsecurity.models.GenericResponse;
import com.contrastsecurity.models.HttpRequestResponse;
import com.contrastsecurity.models.JobOutcomePolicy;
import com.contrastsecurity.models.Libraries;
import com.contrastsecurity.models.LibraryScores;
import com.contrastsecurity.models.LibraryStats;
import com.contrastsecurity.models.MakeRequestResponse;
import com.contrastsecurity.models.MetadataEntity;
import com.contrastsecurity.models.MetadataFilterResponse;
import com.contrastsecurity.models.NotificationsResponse;
import com.contrastsecurity.models.Organizations;
import com.contrastsecurity.models.PropertyResource;
import com.contrastsecurity.models.RecommendationResponse;
import com.contrastsecurity.models.RouteCoverageBySessionIDAndMetadataRequest;
import com.contrastsecurity.models.RouteCoverageResponse;
import com.contrastsecurity.models.Rules;
import com.contrastsecurity.models.SecurityCheck;
import com.contrastsecurity.models.ServerTagsResponse;
import com.contrastsecurity.models.Servers;
import com.contrastsecurity.models.StoryResponse;
import com.contrastsecurity.models.Tag;
import com.contrastsecurity.models.Tags;
import com.contrastsecurity.models.TagsResponse;
import com.contrastsecurity.models.TraceFilterBody;
import com.contrastsecurity.models.TraceListing;
import com.contrastsecurity.models.TraceNotesResponse;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.models.TracesWithResponse;
import com.contrastsecurity.models.Users;
import com.contrastsecurity.models.VulnerabilityTrend;
import com.contrastsecurity.models.dtm.ApplicationCreateRequest;
import com.contrastsecurity.models.dtm.AttestationCreateRequest;
import com.contrastsecurity.sdk.UserAgentProduct;
import com.contrastsecurity.sdk.internal.GsonFactory;
import com.contrastsecurity.sdk.scan.ScanManager;
import com.contrastsecurity.sdk.scan.ScanManagerImpl;
import com.contrastsecurity.utils.ContrastSDKUtils;
import com.contrastsecurity.utils.MetadataDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ContrastSDK {
    private final String apiKey;
    private final String serviceKey;
    private final String user;
    private String restApiURL;
    private final UrlBuilder urlBuilder;
    private final Gson gson;
    Proxy proxy;
    private final String userAgent;
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    private static final int BUFFER_SIZE = 4096;
    public static final int DEFAULT_CONNECTION_TIMEOUT = -1;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    private static final int BAD_REQUEST = 400;
    private static final int SERVER_ERROR = 500;
    private static final List<Integer> CREATE_APPLICATION_ERROR_RESPONSE = Arrays.asList(400, 409, 412, 500);
    private static final String DEFAULT_API_URL = "https://app.contrastsecurity.com/Contrast/api";
    private static final String LOCALHOST_API_URL = "http://localhost:19080/Contrast/api";
    private static final String DEFAULT_AGENT_PROFILE = "default";

    private ContrastSDK(String user, String serviceKey, String apiKey, UserAgentProduct component) {
        this.user = user;
        this.serviceKey = serviceKey;
        this.apiKey = apiKey;
        this.userAgent = ContrastSDK.buildUserAgent(component);
        this.restApiURL = DEFAULT_API_URL;
        ContrastSDKUtils.validateUrl(this.restApiURL);
        this.urlBuilder = UrlBuilder.getInstance();
        this.gson = GsonFactory.create();
        this.proxy = Proxy.NO_PROXY;
    }

    static String buildUserAgent(UserAgentProduct product) {
        UserAgentProduct platform = UserAgentProduct.of("Java", System.getProperty("java.runtime.version"));
        UserAgentProduct sdk = UserAgentProduct.of("contrast-sdk-java", "3.3");
        return Stream.of(product, sdk, platform).filter(Objects::nonNull).map(UserAgentProduct::toEncodedString).collect(Collectors.joining(" "));
    }

    public ScanManager scan(String organizationId) {
        return new ScanManagerImpl(this, this.gson, organizationId);
    }

    public AssessLicenseOverview getAssessLicensing(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getAssessLicensingUrl(organizationId));){
            AssessLicenseOverview assessLicenseOverview;
            try (InputStreamReader reader = new InputStreamReader(is);){
                assessLicenseOverview = (AssessLicenseOverview)this.gson.fromJson((Reader)reader, AssessLicenseOverview.class);
            }
            return assessLicenseOverview;
        }
    }

    public VulnerabilityTrend getYearlyVulnTrend(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getYearlyVulnTrendUrl(organizationId));){
            VulnerabilityTrend vulnerabilityTrend;
            try (InputStreamReader reader = new InputStreamReader(is);){
                vulnerabilityTrend = (VulnerabilityTrend)this.gson.fromJson((Reader)reader, VulnerabilityTrend.class);
            }
            return vulnerabilityTrend;
        }
    }

    public VulnerabilityTrend getYearlyNewVulnTrend(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getYearlyNewVulnTrendUrl(organizationId));){
            VulnerabilityTrend vulnerabilityTrend;
            try (InputStreamReader reader = new InputStreamReader(is);){
                vulnerabilityTrend = (VulnerabilityTrend)this.gson.fromJson((Reader)reader, VulnerabilityTrend.class);
            }
            return vulnerabilityTrend;
        }
    }

    public VulnerabilityTrend getYearlyVulnTrendForApplication(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getYearlyVulnTrendForApplicationUrl(organizationId, appId));){
            VulnerabilityTrend vulnerabilityTrend;
            try (InputStreamReader reader = new InputStreamReader(is);){
                vulnerabilityTrend = (VulnerabilityTrend)this.gson.fromJson((Reader)reader, VulnerabilityTrend.class);
            }
            return vulnerabilityTrend;
        }
    }

    public Organizations getProfileOrganizations() throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getProfileOrganizationsUrl());){
            Organizations organizations;
            try (InputStreamReader reader = new InputStreamReader(is);){
                organizations = (Organizations)this.gson.fromJson((Reader)reader, Organizations.class);
            }
            return organizations;
        }
    }

    public Users getOrganizationUsers(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getOrganizationUsersUrl(organizationId));){
            Users users;
            try (InputStreamReader reader = new InputStreamReader(is);){
                users = (Users)this.gson.fromJson((Reader)reader, Users.class);
            }
            return users;
        }
    }

    public Organizations getProfileDefaultOrganizations() throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getProfileDefaultOrganizationUrl());){
            Organizations organizations;
            try (InputStreamReader reader = new InputStreamReader(is);){
                organizations = (Organizations)this.gson.fromJson((Reader)reader, Organizations.class);
            }
            return organizations;
        }
    }

    public Application createApplication(String organizationId, ApplicationCreateRequest request) throws IOException, UnauthorizedException, ApplicationCreateException {
        try (InputStream is = this.makeCreateRequest(HttpMethod.POST, this.urlBuilder.getCreateApplicationUrl(organizationId), this.gson.toJson((Object)request), MediaType.JSON, false);){
            Application application;
            try (InputStreamReader reader = new InputStreamReader(is);){
                Applications response = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
                application = response.getApplication();
            }
            return application;
        }
    }

    public Application getApplicationByNameAndLanguage(String orgId, String appName, AgentType language) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationByNameAndLanguageUrl(orgId, appName, language.name()));){
            Application application;
            try (InputStreamReader reader = new InputStreamReader(is);){
                Applications response = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
                application = response.getApplication();
            }
            return application;
        }
    }

    private InputStream makeCreateRequest(HttpMethod method, String path, String body, MediaType mediaType, boolean setAcceptType) throws IOException, UnauthorizedException, ApplicationCreateException {
        InputStream is;
        int rc;
        String url = this.restApiURL + path;
        HttpURLConnection connection = this.makeConnection(url, method.toString());
        if (mediaType != null && body != null && (method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.POST))) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", mediaType.getType());
            if (setAcceptType) {
                connection.setRequestProperty("Accept", mediaType.getType());
            }
            OutputStream os = connection.getOutputStream();
            byte[] bodyByte = body.getBytes("utf-8");
            os.write(bodyByte, 0, bodyByte.length);
        }
        if (CREATE_APPLICATION_ERROR_RESPONSE.contains(rc = connection.getResponseCode())) {
            is = connection.getErrorStream();
            String message = this.getErrorMessage(is);
            throw new ApplicationCreateException(rc, message);
        }
        if (rc >= 400 && rc < 500) {
            throw new UnauthorizedException(rc);
        }
        is = connection.getInputStream();
        return is;
    }

    private String getErrorMessage(InputStream errorStream) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(errorStream);
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(streamReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
        }
        JsonObject json = (JsonObject)this.gson.fromJson(builder.toString(), JsonObject.class);
        return json.get("messages").getAsString();
    }

    public Applications getApplication(String organizationId, String appId) throws IOException, UnauthorizedException {
        return this.getApplication(organizationId, appId, null);
    }

    public Applications getApplication(String organizationId, String appId, EnumSet<FilterForm.ApplicationExpandValues> expandValues) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationUrl(organizationId, appId, expandValues));){
            Applications applications;
            try (InputStreamReader reader = new InputStreamReader(is);){
                applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
            }
            return applications;
        }
    }

    public Applications getApplications(String organizationId) throws UnauthorizedException, IOException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationsUrl(organizationId));){
            Applications applications;
            try (InputStreamReader reader = new InputStreamReader(is);){
                applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
            }
            return applications;
        }
    }

    public Applications getFilteredApplications(String organizationId, ApplicationFilterForm applicationFilterForm) throws UnauthorizedException, IOException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationFilterUrl(organizationId, applicationFilterForm));){
            Applications applications;
            try (InputStreamReader reader = new InputStreamReader(is);){
                applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
            }
            return applications;
        }
    }

    public Applications getLicensedApplications(String organizationId) throws UnauthorizedException, IOException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLicensedApplicationsUrl(organizationId));){
            Applications applications;
            try (InputStreamReader reader = new InputStreamReader(is);){
                applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
            }
            return applications;
        }
    }

    public Applications getApplicationsNames(String organizationId) throws UnauthorizedException, IOException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getApplicationsNameUrl(organizationId));){
            Applications applications;
            try (InputStreamReader reader = new InputStreamReader(is);){
                applications = (Applications)this.gson.fromJson((Reader)reader, Applications.class);
            }
            return applications;
        }
    }

    public RouteCoverageResponse getRouteCoverage(String organizationId, String appId, RouteCoverageBySessionIDAndMetadataRequest metadata) throws IOException, UnauthorizedException {
        try (InputStream is = metadata == null ? this.makeRequest(HttpMethod.GET, this.urlBuilder.getRouteCoverageUrl(organizationId, appId)) : this.makeRequestWithBody(HttpMethod.POST, this.urlBuilder.getRouteCoverageWithMetadataUrl(organizationId, appId), this.gson.toJson((Object)metadata), MediaType.JSON);){
            RouteCoverageResponse routeCoverageResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                routeCoverageResponse = (RouteCoverageResponse)this.gson.fromJson((Reader)reader, RouteCoverageResponse.class);
            }
            return routeCoverageResponse;
        }
    }

    public Coverage getCoverage(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getCoverageUrl(organizationId, appId));){
            Coverage coverage;
            try (InputStreamReader reader = new InputStreamReader(is);){
                coverage = (Coverage)this.gson.fromJson((Reader)reader, Coverage.class);
            }
            return coverage;
        }
    }

    public Libraries getLibraries(String organizationId, LibraryFilterForm filterForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibrariesUrl(organizationId, filterForm));){
            Libraries libraries;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraries = (Libraries)this.gson.fromJson((Reader)reader, Libraries.class);
            }
            return libraries;
        }
    }

    public Libraries getLibrariesWithFilter(String organizationId, LibraryFilterForm filterForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibrariesFilterUrl(organizationId, filterForm));){
            Libraries libraries;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraries = (Libraries)this.gson.fromJson((Reader)reader, Libraries.class);
            }
            return libraries;
        }
    }

    public Libraries getLibraries(String organizationId, String appId) throws IOException, UnauthorizedException {
        return this.getLibraries(organizationId, appId, null);
    }

    public Libraries getLibraries(String organizationId, String appId, EnumSet<FilterForm.LibrariesExpandValues> expandValues) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibrariesUrl(organizationId, appId, expandValues));){
            Libraries libraries;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraries = (Libraries)this.gson.fromJson((Reader)reader, Libraries.class);
            }
            return libraries;
        }
    }

    public Libraries getLibrariesWithFilter(String organizationId, String appId, LibraryFilterForm filterForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibrariesFilterUrl(organizationId, appId, filterForm));){
            Libraries libraries;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraries = (Libraries)this.gson.fromJson((Reader)reader, Libraries.class);
            }
            return libraries;
        }
    }

    public LibraryScores getLibraryScores(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibraryScoresUrl(organizationId));){
            LibraryScores libraryScores;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraryScores = (LibraryScores)this.gson.fromJson((Reader)reader, LibraryScores.class);
            }
            return libraryScores;
        }
    }

    public LibraryStats getLibraryStats(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getLibraryStatsUrl(organizationId));){
            LibraryStats libraryStats;
            try (InputStreamReader reader = new InputStreamReader(is);){
                libraryStats = (LibraryStats)this.gson.fromJson((Reader)reader, LibraryStats.class);
            }
            return libraryStats;
        }
    }

    public Servers getServers(String organizationId, ServerFilterForm filterForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getServersUrl(organizationId, filterForm));){
            Servers servers;
            try (InputStreamReader reader = new InputStreamReader(is);){
                servers = (Servers)this.gson.fromJson((Reader)reader, Servers.class);
            }
            return servers;
        }
    }

    public Servers getServersWithFilter(String organizationId, ServerFilterForm filterForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getServersFilterUrl(organizationId, filterForm));){
            Servers servers;
            try (InputStreamReader reader = new InputStreamReader(is);){
                servers = (Servers)this.gson.fromJson((Reader)reader, Servers.class);
            }
            return servers;
        }
    }

    @Deprecated
    public Traces getTraces(String organizationId, String appId, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesByApplicationUrl(organizationId, appId, form));){
            Traces traces;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            }
            return traces;
        }
    }

    public Traces getTraces(String organizationId, String appId, TraceFilterBody filters) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequestWithBody(HttpMethod.POST, this.urlBuilder.getTracesWithBodyUrl(organizationId, appId), this.gson.toJson((Object)filters), MediaType.JSON);){
            Traces traces;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            }
            return traces;
        }
    }

    public TracesWithResponse getTracesWithResponse(String organizationId, String appId, TraceFilterForm form) throws IOException, UnauthorizedException {
        MakeRequestResponse mrr = this.makeRequestWithResponse(HttpMethod.GET, this.urlBuilder.getTracesByApplicationUrl(organizationId, appId, form));
        try (InputStreamReader reader = new InputStreamReader(mrr.is);){
            TracesWithResponse twr = new TracesWithResponse();
            twr.t = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            twr.rc = mrr.rc;
            TracesWithResponse tracesWithResponse = twr;
            return tracesWithResponse;
        }
    }

    public TraceNotesResponse getNotes(String organizationId, String appId, String traceId, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getNotesByApplicationUrl(organizationId, appId, traceId, form));){
            TraceNotesResponse traceNotesResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traceNotesResponse = (TraceNotesResponse)this.gson.fromJson((Reader)reader, TraceNotesResponse.class);
            }
            return traceNotesResponse;
        }
    }

    public RecommendationResponse getRecommendation(String organizationId, String traceId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getRecommendationByTraceId(organizationId, traceId));){
            RecommendationResponse recommendationResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                recommendationResponse = (RecommendationResponse)this.gson.fromJson((Reader)reader, RecommendationResponse.class);
            }
            return recommendationResponse;
        }
    }

    public StoryResponse getStory(String organizationId, String traceId) throws IOException, UnauthorizedException {
        String inputString;
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getStoryByTraceId(organizationId, traceId));
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) > 0) {
                bos.write(buffer, 0, read);
            }
            inputString = bos.toString(StandardCharsets.UTF_8.name());
        }
        StoryResponse story = (StoryResponse)this.gson.fromJson(inputString, StoryResponse.class);
        JsonObject object = (JsonObject)new JsonParser().parse(inputString);
        JsonObject storyObject = (JsonObject)object.get("story");
        if (storyObject != null) {
            JsonArray chaptersArray = (JsonArray)storyObject.get("chapters");
            List<Chapter> chapters = story.getStory().getChapters();
            if (chapters == null) {
                chapters = new ArrayList<Chapter>();
            } else {
                chapters.clear();
            }
            for (int i = 0; i < chaptersArray.size(); ++i) {
                JsonObject member = (JsonObject)chaptersArray.get(i);
                Chapter chapter = (Chapter)this.gson.fromJson((JsonElement)member, Chapter.class);
                chapters.add(chapter);
                JsonObject properties = (JsonObject)member.get("properties");
                if (properties == null) continue;
                Set entries = properties.entrySet();
                Iterator iter = entries.iterator();
                ArrayList<PropertyResource> propertyResources = new ArrayList<PropertyResource>();
                chapter.setPropertyResources(propertyResources);
                while (iter.hasNext()) {
                    Map.Entry prop = (Map.Entry)iter.next();
                    JsonElement entryValue = (JsonElement)prop.getValue();
                    if (entryValue == null || !entryValue.isJsonObject()) continue;
                    JsonObject obj = (JsonObject)entryValue;
                    JsonElement name = obj.get("name");
                    JsonElement value = obj.get("value");
                    if (name == null || value == null) continue;
                    PropertyResource propertyResource = new PropertyResource();
                    propertyResource.setName(name.getAsString());
                    propertyResource.setValue(value.getAsString());
                    propertyResources.add(propertyResource);
                }
            }
        }
        return story;
    }

    public EventSummaryResponse getEventSummary(String organizationId, String traceId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getEventSummary(organizationId, traceId));){
            EventSummaryResponse eventSummaryResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                EventSummaryResponse eventResource = (EventSummaryResponse)this.gson.fromJson((Reader)reader, EventSummaryResponse.class);
                for (EventResource event : eventResource.getEvents()) {
                    if (event.getCollapsedEvents() != null && !event.getCollapsedEvents().isEmpty()) {
                        this.getCollapsedEventsDetails(event, organizationId, traceId);
                        continue;
                    }
                    EventDetails eventDetails = this.getEventDetails(event, organizationId, traceId);
                    event.setEvent(eventDetails.getEvent());
                }
                eventSummaryResponse = eventResource;
            }
            return eventSummaryResponse;
        }
    }

    private void getCollapsedEventsDetails(EventResource parentEvent, String organizationId, String traceId) throws IOException, UnauthorizedException {
        for (EventResource event : parentEvent.getCollapsedEvents()) {
            EventDetails eventDetails = this.getEventDetails(event, organizationId, traceId);
            event.setEvent(eventDetails.getEvent());
            event.setParent(parentEvent);
        }
    }

    private EventDetails getEventDetails(EventResource event, String organizationId, String traceId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getEventDetails(organizationId, traceId, event.getId()));){
            EventDetails eventDetails;
            try (InputStreamReader reader = new InputStreamReader(is);){
                eventDetails = (EventDetails)this.gson.fromJson((Reader)reader, EventDetails.class);
            }
            return eventDetails;
        }
    }

    public HttpRequestResponse getHttpRequest(String organizationId, String traceId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getHttpRequestByTraceId(organizationId, traceId));){
            HttpRequestResponse httpRequestResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                httpRequestResponse = (HttpRequestResponse)this.gson.fromJson((Reader)reader, HttpRequestResponse.class);
            }
            return httpRequestResponse;
        }
    }

    public TagsResponse getVulnTagsByApplication(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTraceTagsByApplicationUrl(organizationId, appId));){
            TagsResponse tagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                tagsResponse = (TagsResponse)this.gson.fromJson((Reader)reader, TagsResponse.class);
            }
            return tagsResponse;
        }
    }

    public MetadataFilterResponse getSessionMetadataForApplication(String organizationId, String appId, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getSessionMetadataForApplicationUrl(organizationId, appId, form));){
            MetadataFilterResponse metadataFilterResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                metadataFilterResponse = (MetadataFilterResponse)this.gson.fromJson((Reader)reader, MetadataFilterResponse.class);
            }
            return metadataFilterResponse;
        }
    }

    public GenericResponse generateAttestationReport(String organizationId, String appId, AttestationCreateRequest request) throws IOException, UnauthorizedException, ApplicationCreateException {
        try (InputStream is = this.makeCreateRequest(HttpMethod.POST, this.urlBuilder.getAttestationReportByApplicationUrl(organizationId, appId), this.gson.toJson((Object)request), MediaType.JSON, true);){
            GenericResponse genericResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                genericResponse = (GenericResponse)this.gson.fromJson((Reader)reader, GenericResponse.class);
            }
            return genericResponse;
        }
    }

    public void downloadAttestationReport(String organizationId, String userId, String reportId) throws IOException, UnauthorizedException {
        this.downloadFile(HttpMethod.POST, this.urlBuilder.downloadAttestationReportUrl(organizationId, userId, reportId), ".");
    }

    public NotificationsResponse getNotifications(String organizationId, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getNotificationsUrl(organizationId, form));){
            NotificationsResponse notificationsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                notificationsResponse = (NotificationsResponse)this.gson.fromJson((Reader)reader, NotificationsResponse.class);
            }
            return notificationsResponse;
        }
    }

    public ServerTagsResponse getServerTags(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getServerTagsUrl(organizationId, appId));){
            ServerTagsResponse serverTagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                serverTagsResponse = (ServerTagsResponse)this.gson.fromJson((Reader)reader, ServerTagsResponse.class);
            }
            return serverTagsResponse;
        }
    }

    public TagsResponse deleteVulnerabilityTag(String organizationId, String traceId, Tag tag) throws IOException, UnauthorizedException {
        String tagsUrl = this.urlBuilder.deleteTag(organizationId, traceId);
        try (InputStream is = this.makeRequestWithBody(HttpMethod.DELETE, tagsUrl, this.gson.toJson((Object)tag), MediaType.JSON);){
            TagsResponse tagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                tagsResponse = (TagsResponse)this.gson.fromJson((Reader)reader, TagsResponse.class);
            }
            return tagsResponse;
        }
    }

    public TagsResponse getTagsByTrace(String organizationId, String traceId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTagsByTrace(organizationId, traceId));){
            TagsResponse tagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                tagsResponse = (TagsResponse)this.gson.fromJson((Reader)reader, TagsResponse.class);
            }
            return tagsResponse;
        }
    }

    public TagsResponse getTraceTagsByOrganization(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getOrCreateTagsByOrganization(organizationId));){
            TagsResponse tagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                tagsResponse = (TagsResponse)this.gson.fromJson((Reader)reader, TagsResponse.class);
            }
            return tagsResponse;
        }
    }

    public TagsResponse createTag(String organizationId, Tags tags) throws IOException, UnauthorizedException {
        Gson gson = new GsonBuilder().registerTypeAdapter(MetadataEntity.class, (Object)new MetadataDeserializer()).create();
        String tagsUrl = this.urlBuilder.getOrCreateTagsByOrganization(organizationId);
        try (InputStream is = this.makeRequestWithBody(HttpMethod.PUT, tagsUrl, gson.toJson((Object)tags.setTagNamesAndGetTagObject()), MediaType.JSON);){
            TagsResponse tagsResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                tagsResponse = (TagsResponse)gson.fromJson((Reader)reader, TagsResponse.class);
            }
            return tagsResponse;
        }
    }

    public GenericResponse clearNotifications(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.PUT, this.urlBuilder.clearNotificationsUrl(organizationId));){
            GenericResponse genericResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                genericResponse = (GenericResponse)this.gson.fromJson((Reader)reader, GenericResponse.class);
            }
            return genericResponse;
        }
    }

    public Traces getTracesInOrg(String organizationId, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesByOrganizationUrl(organizationId, form));){
            Traces traces;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            }
            return traces;
        }
    }

    public TraceListing getTraceFilters(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTraceListingUrl(organizationId, appId, TraceFilterType.VULNTYPE));){
            TraceListing traceListing;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traceListing = (TraceListing)this.gson.fromJson((Reader)reader, TraceListing.class);
            }
            return traceListing;
        }
    }

    public TraceListing getTraceFiltersByType(String organizationId, String appId, TraceFilterType type) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTraceListingUrl(organizationId, appId, type));){
            TraceListing traceListing;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traceListing = (TraceListing)this.gson.fromJson((Reader)reader, TraceListing.class);
            }
            return traceListing;
        }
    }

    public Traces getTracesWithFilter(String organizationId, String appId, TraceFilterType traceFilterType, TraceFilterKeycode keycode, TraceFilterForm form) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesWithFilterUrl(organizationId, appId, traceFilterType, keycode, form));){
            Traces traces;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            }
            return traces;
        }
    }

    public GenericResponse setTraceStatus(String organizationId, String statusRequest) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequestWithBody(HttpMethod.PUT, this.urlBuilder.setTraceStatus(organizationId), statusRequest, MediaType.JSON);){
            GenericResponse genericResponse;
            try (InputStreamReader reader = new InputStreamReader(is);){
                genericResponse = (GenericResponse)this.gson.fromJson((Reader)reader, GenericResponse.class);
            }
            return genericResponse;
        }
    }

    @Deprecated
    public Traces getTraceFilterByRule(String organizationId, String appId, List<String> ruleNames) throws IOException, UnauthorizedException {
        TraceFilterForm ruleNameForm = new TraceFilterForm();
        ruleNameForm.setVulnTypes(ruleNames);
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getTracesByApplicationUrl(organizationId, appId, ruleNameForm));){
            Traces traces;
            try (InputStreamReader reader = new InputStreamReader(is);){
                traces = (Traces)this.gson.fromJson((Reader)reader, Traces.class);
            }
            return traces;
        }
    }

    public SecurityCheck makeSecurityCheck(String organizationId, SecurityCheckForm securityCheckForm) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequestWithBody(HttpMethod.POST, this.urlBuilder.getSecurityCheckUrl(organizationId), this.gson.toJson((Object)securityCheckForm), MediaType.JSON);){
            SecurityCheck securityCheck;
            try (InputStreamReader reader = new InputStreamReader(is);){
                SecurityCheckResponse response = (SecurityCheckResponse)this.gson.fromJson((Reader)reader, SecurityCheckResponse.class);
                securityCheck = response.getSecurityCheck();
            }
            return securityCheck;
        }
    }

    public List<JobOutcomePolicy> getEnabledJobOutcomePolicies(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getEnabledJobOutcomePolicyListUrl(organizationId));){
            List<JobOutcomePolicy> list;
            try (InputStreamReader reader = new InputStreamReader(is);){
                JobOutcomePolicyListResponse response = (JobOutcomePolicyListResponse)this.gson.fromJson((Reader)reader, JobOutcomePolicyListResponse.class);
                list = response.getPolicies();
            }
            return list;
        }
    }

    public List<JobOutcomePolicy> getEnabledJoboutcomePoliciesByApplication(String organizationId, String appId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getEnabledJobOutcomePolicyListUrlByApplication(organizationId, appId));){
            List<JobOutcomePolicy> list;
            try (InputStreamReader reader = new InputStreamReader(is);){
                JobOutcomePolicyListResponse response = (JobOutcomePolicyListResponse)this.gson.fromJson((Reader)reader, JobOutcomePolicyListResponse.class);
                list = response.getPolicies();
            }
            return list;
        }
    }

    public Rules getRules(String organizationId) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getRules(organizationId));){
            Rules rules;
            try (InputStreamReader reader = new InputStreamReader(is);){
                rules = (Rules)this.gson.fromJson((Reader)reader, Rules.class);
            }
            return rules;
        }
    }

    public byte[] getAgent(AgentType type, String organizationId, String profileName) throws IOException, UnauthorizedException {
        try (InputStream is = this.makeRequest(HttpMethod.GET, this.urlBuilder.getAgentUrl(type, organizationId, profileName));){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, read);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public byte[] getAgent(AgentType type, String organizationId) throws IOException, UnauthorizedException {
        return this.getAgent(type, organizationId, DEFAULT_AGENT_PROFILE);
    }

    public InputStream makeRequestWithBody(HttpMethod method, String path, String body, MediaType mediaType) throws IOException, UnauthorizedException {
        int rc;
        String url = this.restApiURL + path;
        HttpURLConnection connection = this.makeConnection(url, method.toString());
        if (mediaType != null && body != null && (method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.DELETE))) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", mediaType.getType());
            try (OutputStream os = connection.getOutputStream();){
                byte[] bodyByte = body.getBytes(StandardCharsets.UTF_8);
                os.write(bodyByte, 0, bodyByte.length);
            }
        }
        if ((rc = connection.getResponseCode()) >= 400) {
            throw HttpResponseException.fromConnection(connection, "Received unexpected status code from Contrast");
        }
        return connection.getInputStream();
    }

    public InputStream makeRequest(HttpMethod method, String path) throws IOException, UnauthorizedException {
        return this.makeRequestWithResponse((HttpMethod)method, (String)path).is;
    }

    public MakeRequestResponse makeRequestWithResponse(HttpMethod method, String path) throws IOException, UnauthorizedException {
        String url = this.restApiURL + path;
        HttpURLConnection connection = this.makeConnection(url, method.toString());
        int rc = connection.getResponseCode();
        if (rc >= 400) {
            throw HttpResponseException.fromConnection(connection, "Received unexpected status code from Contrast");
        }
        MakeRequestResponse mrr = new MakeRequestResponse();
        mrr.is = connection.getInputStream();
        mrr.rc = rc;
        return mrr;
    }

    public void downloadFile(HttpMethod method, String path, String saveDir) throws IOException, UnauthorizedException {
        String fileURL = this.restApiURL + path;
        HttpURLConnection connection = this.makeConnection(fileURL, method.toString());
        connection.setRequestProperty("accept", "application/json, text/plain, */*");
        connection.setRequestProperty("accept-encoding", "gzip, deflate, br");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String fileName = "";
            String disposition = connection.getHeaderField("Content-Disposition");
            String contentType = connection.getContentType();
            int contentLength = connection.getContentLength();
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    fileName = disposition.substring(index + 9, disposition.length());
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
            }
            System.out.println("fileName = " + fileName);
            InputStream inputStream = connection.getInputStream();
            String saveFilePath = saveDir + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            int bytesRead = -1;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
            System.out.println("File downloaded to path: " + saveFilePath);
        } else {
            System.out.println("No file to download. Server replied HTTP code: " + responseCode);
        }
        connection.disconnect();
    }

    public HttpURLConnection makeConnection(String url, String method) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(this.proxy);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", ContrastSDKUtils.makeAuthorizationToken(this.user, this.serviceKey));
        connection.setRequestProperty("API-Key", this.apiKey);
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setUseCaches(false);
        if (this.connectionTimeout > -1) {
            connection.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > -1) {
            connection.setReadTimeout(this.readTimeout);
        }
        return connection;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public String getRestApiURL() {
        return this.restApiURL;
    }

    public static class Builder {
        private final String user;
        private final String serviceKey;
        private final String apiKey;
        private Proxy proxy;
        private String restApiURL;
        private UserAgentProduct product;

        public Builder(String user, String serviceKey, String apiKey) {
            this.user = user;
            this.serviceKey = serviceKey;
            this.apiKey = apiKey;
            this.restApiURL = ContrastSDK.DEFAULT_API_URL;
            ContrastSDKUtils.validateUrl(this.restApiURL);
            this.proxy = Proxy.NO_PROXY;
        }

        public Builder withApiUrl(String apiUrl) {
            ContrastSDKUtils.validateUrl(apiUrl);
            this.restApiURL = ContrastSDKUtils.ensureApi(apiUrl);
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withUserAgentProduct(UserAgentProduct product) {
            this.product = product;
            return this;
        }

        public ContrastSDK build() {
            ContrastSDK sdk = new ContrastSDK(this.user, this.serviceKey, this.apiKey, this.product);
            sdk.restApiURL = this.restApiURL;
            sdk.proxy = this.proxy;
            return sdk;
        }
    }
}

