/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.models;

import com.contrastsecurity.models.Event;
import com.contrastsecurity.models.EventItem;
import com.contrastsecurity.models.EventModel;
import com.contrastsecurity.models.Parameter;
import com.contrastsecurity.models.Stacktrace;
import java.util.ArrayList;
import java.util.List;

public class EventResource
extends EventModel {
    public static final String RED = "RED";
    public static final String CONTENT = "CONTENT";
    public static final String CODE = "CODE";
    public static final String BOLD = "BOLD";
    public static final String CUSTOM_CODE = "CUSTOM_CODE";
    public static final String CUSTOM_RED = "CUSTOM_RED";
    private String id;
    private boolean important;
    private String type;
    private String description;
    private int dupes;
    private String extraDetails;
    private List<EventResource> collapsedEvents;
    private Event event;
    private EventItem[] items;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDupes() {
        return this.dupes;
    }

    public void setDupes(int dupes) {
        this.dupes = dupes;
    }

    public String getExtraDetails() {
        return this.extraDetails;
    }

    public void setExtraDetails(String extraDetails) {
        this.extraDetails = extraDetails;
    }

    public List<EventResource> getCollapsedEvents() {
        return this.collapsedEvents;
    }

    public void setCollapsedEvents(List<EventResource> collapsedEvents) {
        this.collapsedEvents = collapsedEvents;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventResource other = (EventResource)obj;
        return this.id == other.id;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public EventItem[] getItems() {
        if (this.items == null && this.event != null) {
            ArrayList<EventItem> eventItems = new ArrayList<EventItem>();
            EventItem eventItem = new EventItem(this, BOLD, "Class.Method", false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, CONTENT, this.event.getClazz() + '.' + this.event.getMethod(), false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, BOLD, "Object", false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, CONTENT, this.event.getfObject(), false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, BOLD, "Return", false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, CONTENT, this.event.getfReturn(), false);
            eventItems.add(eventItem);
            eventItem = new EventItem(this, BOLD, "Parameters", false);
            eventItems.add(eventItem);
            if (this.event.getParameters() != null) {
                for (Parameter paremeter : this.event.getParameters()) {
                    if (paremeter.getParameter() == null) continue;
                    eventItem = new EventItem(this, CONTENT, paremeter.getParameter(), false);
                    eventItems.add(eventItem);
                }
            }
            eventItem = new EventItem(this, BOLD, "Stack Trace", false);
            eventItems.add(eventItem);
            if (this.event.getStacktraces() != null) {
                boolean first = true;
                for (Stacktrace stacktrace : this.event.getStacktraces()) {
                    if (first) {
                        eventItem = stacktrace.getType().equals("custom") ? new EventItem(this, CUSTOM_RED, stacktrace.getDescription(), true) : new EventItem(this, RED, stacktrace.getDescription(), true);
                        eventItems.add(eventItem);
                        first = false;
                        continue;
                    }
                    eventItem = stacktrace.getType().equals("custom") ? new EventItem(this, CUSTOM_CODE, stacktrace.getDescription(), true) : new EventItem(this, CODE, stacktrace.getDescription(), true);
                    eventItems.add(eventItem);
                    first = false;
                }
            }
            this.items = eventItems.toArray(new EventItem[0]);
        }
        return this.items;
    }

    public String toString() {
        return this.description;
    }
}

