/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.exceptions;

import com.contrastsecurity.exceptions.ContrastException;
import com.contrastsecurity.exceptions.ResourceNotFoundException;
import com.contrastsecurity.exceptions.UnauthorizedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class HttpResponseException
extends ContrastException {
    private final String method;
    private final String path;
    private final int code;
    private final String status;
    private final String body;

    public static HttpResponseException fromConnection(HttpURLConnection connection, String message) throws IOException {
        String method = connection.getRequestMethod();
        String path = connection.getURL().getPath();
        int code = connection.getResponseCode();
        ExceptionFactory factory = HttpResponseException.factoryFromResponseCode(code);
        String body = HttpResponseException.readBody(connection, code);
        String status = connection.getResponseMessage();
        return factory.create(message, method, path, code, status, body);
    }

    private static ExceptionFactory factoryFromResponseCode(int code) {
        switch (code) {
            case 401: 
            case 403: {
                return UnauthorizedException::new;
            }
            case 404: {
                return ResourceNotFoundException::new;
            }
        }
        return HttpResponseException::new;
    }

    private static String readBody(HttpURLConnection connection, int code) throws IOException {
        String body;
        try (InputStream is = code >= 400 ? connection.getErrorStream() : connection.getInputStream();
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            if (is == null) {
                body = null;
            } else {
                int read;
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, read);
                }
                body = bos.toString(StandardCharsets.UTF_8.name());
            }
        }
        return body;
    }

    public HttpResponseException(String message, String method, String path, int code, String status) {
        this(message, method, path, code, status, null);
    }

    public HttpResponseException(String message, String method, String path, int code, String status, String body) {
        super(message);
        this.method = Objects.requireNonNull(method);
        this.path = Objects.requireNonNull(path);
        this.code = code;
        this.status = status;
        this.body = body;
    }

    public int getCode() {
        return this.code;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder().append(super.getMessage()).append("\n").append(this.method).append(" ").append(this.path).append("\n\n").append(this.code);
        if (this.status != null) {
            sb.append(" ").append(this.status);
        }
        if (this.body != null) {
            sb.append("\n\n").append(this.body);
        }
        return sb.toString();
    }

    private static interface ExceptionFactory {
        public HttpResponseException create(String var1, String var2, String var3, int var4, String var5, String var6);
    }
}

