/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.vault.compiler;

import com.contentful.vault.ModelHelper;
import com.contentful.vault.Resource;
import com.contentful.vault.SpaceHelper;
import com.contentful.vault.compiler.Injection;
import com.contentful.vault.compiler.ModelInjection;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class SpaceInjection
extends Injection {
    private final List<ModelInjection> models;
    private final String dbName;
    private final int dbVersion;
    private final String copyPath;
    private FieldSpec specModels;
    private FieldSpec specTypes;

    public SpaceInjection(String remoteId, ClassName className, TypeElement originatingElement, List<ModelInjection> models, String dbName, int dbVersion, String copyPath) {
        super(remoteId, className, originatingElement);
        this.models = models;
        this.dbName = dbName;
        this.dbVersion = dbVersion;
        this.copyPath = copyPath;
    }

    @Override
    TypeSpec.Builder getTypeSpecBuilder() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.className.simpleName()).superclass((TypeName)ClassName.get(SpaceHelper.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.appendDbName(builder);
        this.appendDbVersion(builder);
        this.appendModels(builder);
        this.appendTypes(builder);
        this.appendCopyPath(builder);
        this.appendConstructor(builder);
        return builder;
    }

    private void appendConstructor(TypeSpec.Builder builder) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (ModelInjection model : this.models) {
            ClassName enclosingClassName = ClassName.get((TypeElement)model.originatingElement);
            ctor.addStatement("$N.put($L.class, new $L())", new Object[]{this.specModels, enclosingClassName, model.className});
            ctor.addStatement("$N.put($S, $L.class)", new Object[]{this.specTypes, model.remoteId, enclosingClassName});
        }
        builder.addMethod(ctor.build());
    }

    private void appendTypes(TypeSpec.Builder builder) {
        ParameterizedTypeName classTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Resource.class)});
        this.specTypes = this.createMapWithInitializer("types", LinkedHashMap.class, (TypeName)ClassName.get(String.class), (TypeName)classTypeName).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        builder.addField(this.specTypes);
        builder.addMethod(this.createGetterImpl(this.specTypes, "getTypes").build());
    }

    private void appendModels(TypeSpec.Builder builder) {
        ParameterizedTypeName classTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        ParameterizedTypeName helperTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(ModelHelper.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        this.specModels = this.createMapWithInitializer("models", LinkedHashMap.class, (TypeName)classTypeName, (TypeName)helperTypeName).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        builder.addField(this.specModels);
        builder.addMethod(this.createGetterImpl(this.specModels, "getModels").build());
    }

    private void appendDbVersion(TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder((String)"getDatabaseVersion").returns(Integer.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $L", new Object[]{this.dbVersion}).build());
    }

    private void appendDbName(TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder((String)"getDatabaseName").returns(String.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $S", new Object[]{this.dbName}).build());
    }

    private void appendCopyPath(TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder((String)"getCopyPath").returns(String.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $S", new Object[]{this.copyPath}).build());
    }
}

