/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.vault.compiler;

import com.contentful.java.cda.CDAType;
import com.contentful.vault.ContentType;
import com.contentful.vault.Field;
import com.contentful.vault.FieldMeta;
import com.contentful.vault.Resource;
import com.contentful.vault.Space;
import com.contentful.vault.compiler.FieldsInjection;
import com.contentful.vault.compiler.Injection;
import com.contentful.vault.compiler.ModelInjection;
import com.contentful.vault.compiler.SpaceInjection;
import com.contentful.vault.compiler.SqliteUtils;
import com.google.common.base.Joiner;
import com.squareup.javapoet.ClassName;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public class Processor
extends AbstractProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private static final String FQ_ASSET = "com.contentful.vault.Asset";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ContentType.class.getCanonicalName());
        types.add(Space.class.getCanonicalName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Injection injection : this.findAndParseTargets(roundEnv)) {
            try {
                injection.brewJava().writeTo(this.filer);
            }
            catch (Exception e) {
                TypeElement element = injection.originatingElement;
                this.error(element, "Failed writing injection for \"%s\", message: %s", element.getQualifiedName(), e.getMessage());
            }
        }
        return true;
    }

    private Set<Injection> findAndParseTargets(RoundEnvironment env) {
        LinkedHashMap<TypeElement, ModelInjection> models = new LinkedHashMap<TypeElement, ModelInjection>();
        LinkedHashMap<TypeElement, FieldsInjection> fields = new LinkedHashMap<TypeElement, FieldsInjection>();
        LinkedHashMap<TypeElement, SpaceInjection> spaces = new LinkedHashMap<TypeElement, SpaceInjection>();
        for (Element element : env.getElementsAnnotatedWith(ContentType.class)) {
            try {
                this.parseContentType((TypeElement)element, models);
            }
            catch (Exception e) {
                this.parsingError(element, ContentType.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(Space.class)) {
            try {
                this.parseSpace((TypeElement)element, spaces, models);
            }
            catch (Exception e) {
                this.parsingError(element, Space.class, e);
            }
        }
        for (ModelInjection modelInjection : models.values()) {
            fields.put(modelInjection.originatingElement, this.createFieldsInjection(modelInjection));
        }
        LinkedHashSet<Injection> result = new LinkedHashSet<Injection>();
        result.addAll(models.values());
        result.addAll(fields.values());
        result.addAll(spaces.values());
        return result;
    }

    private FieldsInjection createFieldsInjection(ModelInjection injection) {
        ClassName name = this.getInjectionClassName(injection.originatingElement, "$Fields");
        return new FieldsInjection(injection.remoteId, name, injection.originatingElement, injection.fields);
    }

    private void parseSpace(TypeElement element, Map<TypeElement, SpaceInjection> spaces, Map<TypeElement, ModelInjection> models) {
        Space annotation = element.getAnnotation(Space.class);
        String id = annotation.value();
        if (id.isEmpty()) {
            this.error(element, "@%s id may not be empty. (%s)", Space.class.getSimpleName(), element.getQualifiedName());
            return;
        }
        TypeMirror spaceMirror = this.elementUtils.getTypeElement(Space.class.getName()).asType();
        ArrayList<ModelInjection> includedModels = new ArrayList<ModelInjection>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), spaceMirror)) continue;
            Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> items = annotationMirror.getElementValues().entrySet();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : items) {
                if (!"models".equals(entry.getKey().getSimpleName().toString())) continue;
                List l = (List)entry.getValue().getValue();
                if (l.size() == 0) {
                    this.error(element, "@%s models must not be empty. (%s)", Space.class.getSimpleName(), element.getQualifiedName());
                    return;
                }
                LinkedHashSet<String> modelIds = new LinkedHashSet<String>();
                for (Object model : l) {
                    TypeElement e = (TypeElement)((Object)((Type)((Attribute)model).getValue()).asElement());
                    ModelInjection modelInjection = models.get(e);
                    if (modelInjection == null) {
                        return;
                    }
                    String rid = modelInjection.remoteId;
                    if (!modelIds.add(rid)) {
                        this.error(element, "@%s includes multiple models with the same id \"%s\". (%s)", Space.class.getSimpleName(), rid, element.getQualifiedName());
                        return;
                    }
                    includedModels.add(modelInjection);
                }
            }
        }
        ClassName injectionClassName = this.getInjectionClassName(element, "$$SpaceHelper");
        String string = "space_" + SqliteUtils.hashForId(id);
        String copyPath = (String)StringUtils.defaultIfBlank((CharSequence)annotation.copyPath(), null);
        spaces.put(element, new SpaceInjection(id, injectionClassName, element, includedModels, string, annotation.dbVersion(), copyPath));
    }

    private void parseContentType(TypeElement element, Map<TypeElement, ModelInjection> models) {
        String id = element.getAnnotation(ContentType.class).value();
        if (id.isEmpty()) {
            this.error(element, "@%s id may not be empty. (%s)", ContentType.class.getSimpleName(), element.getQualifiedName());
            return;
        }
        if (!this.isSubtypeOfType(element.asType(), Resource.class.getName())) {
            this.error(element, "Classes annotated with @%s must extend \"" + Resource.class.getName() + "\". (%s)", ContentType.class.getSimpleName(), element.getQualifiedName());
            return;
        }
        LinkedHashSet<FieldMeta> fields = new LinkedHashSet<FieldMeta>();
        LinkedHashSet<String> memberIds = new LinkedHashSet<String>();
        for (Element element2 : element.getEnclosedElements()) {
            Field field = element2.getAnnotation(Field.class);
            if (field == null) continue;
            String fieldId = field.value();
            if (fieldId.isEmpty()) {
                fieldId = element2.getSimpleName().toString();
            }
            if (!memberIds.add(fieldId)) {
                this.error(element, "@%s for the same id (\"%s\") was used multiple times in the same class. (%s)", Field.class.getSimpleName(), fieldId, element.getQualifiedName());
                return;
            }
            FieldMeta.Builder fieldBuilder = FieldMeta.builder();
            if (this.isList(element2)) {
                DeclaredType declaredType = (DeclaredType)element2.asType();
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (typeArguments.size() == 0) {
                    this.error(element, "Array fields must have a type parameter specified. (%s.%s)", element.getQualifiedName(), element2.getSimpleName());
                    return;
                }
                TypeMirror arrayType = typeArguments.get(0);
                if (!this.isValidListType(arrayType)) {
                    this.error(element, "Invalid list type \"%s\" specified. (%s.%s)", arrayType.toString(), element.getQualifiedName(), element2.getSimpleName());
                    return;
                }
                String sqliteType = null;
                if (String.class.getName().equals(arrayType.toString())) {
                    sqliteType = SqliteUtils.typeForClass(List.class.getName());
                }
                fieldBuilder.setSqliteType(sqliteType).setArrayType(arrayType.toString());
            } else {
                TypeMirror enclosedType = element2.asType();
                String linkType = this.getLinkType(enclosedType);
                String sqliteType = null;
                if (linkType == null && (sqliteType = SqliteUtils.typeForClass(enclosedType.toString())) == null) {
                    this.error(element, "@%s specified for unsupported type (\"%s\"). (%s.%s)", Field.class.getSimpleName(), enclosedType.toString(), element.getQualifiedName(), element2.getSimpleName());
                    return;
                }
                fieldBuilder.setSqliteType(sqliteType).setLinkType(linkType);
            }
            fields.add(fieldBuilder.setId(fieldId).setName(element2.getSimpleName().toString()).setType(element2.asType()).build());
        }
        ClassName injectionClassName = this.getInjectionClassName(element, "$$ModelHelper");
        String string = "entry_" + SqliteUtils.hashForId(id);
        models.put(element, new ModelInjection(id, injectionClassName, element, string, fields));
    }

    private boolean isValidListType(TypeMirror typeMirror) {
        return this.isSubtypeOfType(typeMirror, String.class.getName()) || this.isSubtypeOfType(typeMirror, Resource.class.getName());
    }

    private boolean isList(Element element) {
        TypeMirror typeMirror = element.asType();
        if (List.class.getName().equals(typeMirror.toString())) {
            return true;
        }
        return typeMirror instanceof DeclaredType && List.class.getName().equals(((DeclaredType)typeMirror).asElement().toString());
    }

    private ClassName getInjectionClassName(TypeElement typeElement, String suffix) {
        ClassName specClassName = ClassName.get((TypeElement)typeElement);
        return ClassName.get((String)specClassName.packageName(), (String)(Joiner.on((char)'$').join((Iterable)specClassName.simpleNames()) + suffix), (String[])new String[0]);
    }

    private String getLinkType(TypeMirror typeMirror) {
        if (this.isSubtypeOfType(typeMirror, Resource.class.getName())) {
            if (this.isSubtypeOfType(typeMirror, FQ_ASSET)) {
                return CDAType.ASSET.toString();
            }
            return CDAType.ENTRY.toString();
        }
        return null;
    }

    private void parsingError(Element element, Class<? extends Annotation> annotation, Exception e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        this.error(element, "Unable to parse @%s injection.\n\n%s", annotation.getSimpleName(), stackTrace);
    }

    private void error(Element element, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(typeMirror.toString())) {
            return true;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }
}

