/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.vault.compiler;

import com.contentful.vault.FieldMeta;
import com.contentful.vault.ModelHelper;
import com.contentful.vault.SpaceHelper;
import com.contentful.vault.compiler.Injection;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class ModelInjection
extends Injection {
    final String sqlTableName;
    final Set<FieldMeta> fields;
    private FieldSpec specFields;

    public ModelInjection(String remoteId, ClassName className, TypeElement originatingElement, String sqlTableName, Set<FieldMeta> fields) {
        super(remoteId, className, originatingElement);
        this.sqlTableName = sqlTableName;
        this.fields = fields;
    }

    @Override
    TypeSpec.Builder getTypeSpecBuilder() {
        ParameterizedTypeName modelHelperType = ParameterizedTypeName.get((ClassName)ClassName.get(ModelHelper.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.originatingElement)});
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.className.simpleName()).superclass((TypeName)modelHelperType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.appendFields(builder);
        this.appendTableName(builder);
        this.appendCreateStatements(builder);
        this.appendFromCursor(builder);
        this.appendSetField(builder);
        this.appendConstructor(builder);
        return builder;
    }

    private void appendConstructor(TypeSpec.Builder builder) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (FieldMeta f : this.fields) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.add("$N.add($T.builder()", new Object[]{this.specFields, ClassName.get(FieldMeta.class)}).add(".setId($S)", new Object[]{f.id()}).add(".setName($S)", new Object[]{f.name()});
            if (f.sqliteType() != null) {
                block.add(".setSqliteType($S)", new Object[]{f.sqliteType()});
            }
            if (f.isLink()) {
                block.add(".setLinkType($S)", new Object[]{f.linkType()});
            }
            if (f.isArray()) {
                block.add(".setArrayType($S)", new Object[]{f.arrayType()});
            }
            block.add(".build());\n", new Object[0]);
            ctor.addCode(block.build());
        }
        builder.addMethod(ctor.build());
    }

    private void appendSetField(TypeSpec.Builder builder) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"setField").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)this.originatingElement), (String)"resource", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(String.class), (String)"name", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Object.class), (String)"value", (Modifier[])new Modifier[0]).build());
        FieldMeta[] array = this.fields.toArray(new FieldMeta[this.fields.size()]);
        for (int i = 0; i < array.length; ++i) {
            FieldMeta field = array[i];
            if (i == 0) {
                method.beginControlFlow("if ($S.equals(name))", new Object[]{field.name()});
            } else {
                method.endControlFlow().beginControlFlow("else if ($S.equals(name))", new Object[]{field.name()});
            }
            method.addStatement("resource.$L = ($T) value", new Object[]{field.name(), field.type()});
        }
        method.endControlFlow().beginControlFlow("else", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("return true", new Object[0]);
        builder.addMethod(method.build());
    }

    private void appendFromCursor(TypeSpec.Builder builder) {
        ClassName modelClassName = ClassName.get((TypeElement)this.originatingElement);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"fromCursor").returns((TypeName)modelClassName).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"android.database", (String)"Cursor", (String[])new String[0]), (String)"cursor", (Modifier[])new Modifier[0]).build());
        String result = "result";
        method.addStatement("$T $N = new $T()", new Object[]{modelClassName, result, modelClassName}).addStatement("setContentType($N, $S)", new Object[]{result, this.remoteId});
        List<FieldMeta> nonLinkFields = this.extractNonLinkFields();
        for (int i = 0; i < nonLinkFields.size(); ++i) {
            FieldMeta field = nonLinkFields.get(i);
            int columnIndex = SpaceHelper.RESOURCE_COLUMNS.length + i;
            String fqClassName = field.type().toString();
            String name = field.name();
            if (String.class.getName().equals(fqClassName)) {
                method.addStatement("$N.$L = cursor.getString($L)", new Object[]{result, name, columnIndex});
                continue;
            }
            if (Boolean.class.getName().equals(fqClassName)) {
                method.addStatement("$N.$L = Integer.valueOf(1).equals(cursor.getInt($L))", new Object[]{result, name, columnIndex});
                continue;
            }
            if (Integer.class.getName().equals(fqClassName)) {
                method.addStatement("$N.$L = cursor.getInt($L)", new Object[]{result, name, columnIndex});
                continue;
            }
            if (Double.class.getName().equals(fqClassName)) {
                method.addStatement("$N.$L = cursor.getDouble($L)", new Object[]{result, name, columnIndex});
                continue;
            }
            if (Map.class.getName().equals(fqClassName)) {
                method.addStatement("$N.$L = fieldFromBlob($T.class, cursor, $L)", new Object[]{result, name, ClassName.get(HashMap.class), columnIndex});
                continue;
            }
            if (!field.isArrayOfSymbols()) continue;
            method.addStatement("$N.$L = fieldFromBlob($T.class, cursor, $L)", new Object[]{result, name, ClassName.get(ArrayList.class), columnIndex});
        }
        method.addStatement("return $N", new Object[]{result});
        builder.addMethod(method.build());
    }

    private void appendCreateStatements(TypeSpec.Builder builder) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"getCreateStatements").returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addStatement("$T list = new $T()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), ParameterizedTypeName.get(ArrayList.class, (Type[])new Type[]{String.class})});
        for (String sql : this.getSqlCreateStatements()) {
            method.addStatement("list.add($S)", new Object[]{sql});
        }
        method.addStatement("return list", new Object[0]);
        builder.addMethod(method.build());
    }

    private void appendTableName(TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder((String)"getTableName").returns((TypeName)ClassName.get(String.class)).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $S", new Object[]{this.sqlTableName}).build());
    }

    private void appendFields(TypeSpec.Builder builder) {
        this.specFields = this.createListWithInitializer("fields", ArrayList.class, (TypeName)ClassName.get(FieldMeta.class)).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        builder.addField(this.specFields);
        builder.addMethod(this.createGetterImpl(this.specFields, "getFields").build());
    }

    List<String> getSqlCreateStatements() {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE `").append(this.sqlTableName).append("` (");
        for (int i = 0; i < SpaceHelper.RESOURCE_COLUMNS.length; ++i) {
            builder.append(SpaceHelper.RESOURCE_COLUMNS[i]);
            if (i >= SpaceHelper.RESOURCE_COLUMNS.length - 1) continue;
            builder.append(", ");
        }
        List<FieldMeta> list = this.extractNonLinkFields();
        for (int i = 0; i < list.size(); ++i) {
            FieldMeta f = list.get(i);
            builder.append(", `").append(f.name()).append("` ").append(f.sqliteType());
        }
        builder.append(");");
        statements.add(builder.toString());
        return statements;
    }

    List<FieldMeta> extractNonLinkFields() {
        ArrayList<FieldMeta> result = new ArrayList<FieldMeta>();
        for (FieldMeta f : this.fields) {
            if (f.isLink() || f.isArray() && !f.isArrayOfSymbols()) continue;
            result.add(f);
        }
        return result;
    }
}

