/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.vault.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

abstract class Injection {
    final String remoteId;
    final ClassName className;
    final TypeElement originatingElement;

    public Injection(String remoteId, ClassName className, TypeElement originatingElement) {
        this.remoteId = remoteId;
        this.className = className;
        this.originatingElement = originatingElement;
    }

    JavaFile brewJava() {
        TypeSpec.Builder typeSpecBuilder = this.getTypeSpecBuilder().addOriginatingElement((Element)this.originatingElement);
        return JavaFile.builder((String)this.className.packageName(), (TypeSpec)typeSpecBuilder.build()).skipJavaLangImports(true).build();
    }

    abstract TypeSpec.Builder getTypeSpecBuilder();

    protected MethodSpec.Builder createGetterImpl(FieldSpec field, String name) {
        return MethodSpec.methodBuilder((String)name).returns(field.type).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $N", new Object[]{field.name});
    }

    protected FieldSpec.Builder createListWithInitializer(String name, Class<? extends List> listClass, TypeName typeName) {
        ParameterizedTypeName listTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{typeName});
        ParameterizedTypeName initializerTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(listClass), (TypeName[])new TypeName[]{typeName});
        return FieldSpec.builder((TypeName)listTypeName, (String)name, (Modifier[])new Modifier[0]).initializer("new $T()", new Object[]{initializerTypeName});
    }

    protected FieldSpec.Builder createMapWithInitializer(String name, Class<? extends Map> mapClass, TypeName keyTypeName, TypeName valueTypeName) {
        ParameterizedTypeName mapTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        ParameterizedTypeName linkedMapTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(mapClass), (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        return FieldSpec.builder((TypeName)mapTypeName, (String)name, (Modifier[])new Modifier[0]).initializer("new $T()", new Object[]{linkedMapTypeName});
    }
}

