/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.vault.compiler;

import com.contentful.vault.BaseFields;
import com.contentful.vault.FieldMeta;
import com.contentful.vault.compiler.Injection;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class FieldsInjection
extends Injection {
    private final Set<FieldMeta> fields;

    public FieldsInjection(String remoteId, ClassName className, TypeElement originatingElement, Set<FieldMeta> fields) {
        super(remoteId, className, originatingElement);
        this.fields = fields;
    }

    @Override
    TypeSpec.Builder getTypeSpecBuilder() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.className.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(BaseFields.class);
        for (FieldMeta field : this.fields) {
            builder.addField(this.createFieldSpec(field));
        }
        return builder;
    }

    private FieldSpec createFieldSpec(FieldMeta field) {
        String name = (String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)field.name());
        if (name == null) {
            throw new IllegalArgumentException("Invalid field with ID '" + field.id() + "' for generated class '" + this.className.simpleName() + "', has no name.");
        }
        return FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{field.name()}).build();
    }
}

