/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDALocale;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.ResourceDeserializer;
import com.contentful.java.cda.ResourceUtils;
import com.contentful.java.cda.SynchronizedSpace;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import retrofit.client.Response;

final class ResourceFactory {
    private static final Gson GSON = ResourceFactory.createGson();

    private ResourceFactory() {
        throw new AssertionError();
    }

    static CDASpace space(Response response) {
        CDASpace space = (CDASpace)ResourceFactory.fromResponse(response);
        ResourceFactory.setDefaultLocale(space);
        return space;
    }

    static CDAArray array(Response response, CDAClient client) {
        CDAArray array = ResourceFactory.fromResponse(response, CDAArray.class);
        array.assets = new HashMap();
        array.entries = new HashMap();
        ResourceUtils.mergeIncludes(array);
        ResourceUtils.localizeResources(array.items(), client.cache.space());
        ResourceUtils.mapResources(array.items(), array.assets, array.entries);
        ResourceUtils.setRawFields(array);
        ResourceUtils.resolveLinks(array, client);
        return array;
    }

    static SynchronizedSpace sync(Response response, SynchronizedSpace old, CDAClient client) {
        HashMap<String, CDAAsset> assets = new HashMap<String, CDAAsset>();
        HashMap<String, CDAEntry> entries = new HashMap<String, CDAEntry>();
        if (old != null) {
            ResourceUtils.mapResources(old.items(), assets, entries);
        }
        SynchronizedSpace result = ResourceUtils.iterate(response, client);
        ResourceUtils.mapResources(result.items(), assets, entries);
        ResourceUtils.mapDeletedResources(result);
        ArrayList items = new ArrayList();
        items.addAll(assets.values());
        items.addAll(entries.values());
        result.items = items;
        result.assets = assets;
        result.entries = entries;
        ResourceUtils.setRawFields(result);
        ResourceUtils.resolveLinks(result, client);
        return result;
    }

    static <T extends CDAResource> T fromResponse(Response response) {
        return (T)ResourceFactory.fromResponse(response, CDAResource.class);
    }

    static <T extends CDAResource> T fromResponse(Response response, Class<T> clazz) {
        try {
            return (T)((CDAResource)GSON.fromJson((Reader)new InputStreamReader(response.getBody().in(), "UTF-8"), clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setDefaultLocale(CDASpace space) {
        for (CDALocale locale : space.locales()) {
            if (!locale.isDefaultLocale()) continue;
            space.defaultLocale = locale;
            break;
        }
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(CDAResource.class, (Object)new ResourceDeserializer()).create();
    }
}

