/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAResource;
import rx.Observable;
import rx.functions.Action1;
import rx.observables.ConnectableObservable;
import rx.schedulers.Schedulers;

final class Callbacks {
    private Callbacks() {
        throw new AssertionError();
    }

    static <O extends CDAResource, C extends CDAResource> CDACallback<C> subscribeAsync(Observable<O> observable, CDACallback<C> callback, CDAClient client) {
        ConnectableObservable connectable = observable.observeOn(Schedulers.io()).publish();
        callback.setSubscription(connectable.subscribe(new SuccessAction(callback, client), (Action1)new FailureAction(callback, client)));
        connectable.connect();
        return callback;
    }

    static class FailureRunnable
    implements Runnable {
        private final Throwable throwable;
        private final CDACallback<? extends CDAResource> callback;

        FailureRunnable(Throwable throwable, CDACallback<? extends CDAResource> callback) {
            this.throwable = throwable;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!this.callback.isCancelled()) {
                this.callback.onFailure(this.throwable);
            }
        }
    }

    static class SuccessRunnable<E extends CDAResource>
    implements Runnable {
        private final E result;
        private final CDACallback<E> callback;

        SuccessRunnable(E result, CDACallback<E> callback) {
            this.result = result;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!this.callback.isCancelled()) {
                this.callback.onSuccess(this.result);
            }
        }
    }

    static class FailureAction
    extends BaseAction<Throwable> {
        FailureAction(CDACallback<? extends CDAResource> callback, CDAClient client) {
            super(callback, client);
        }

        @Override
        protected void doCall(Throwable t) {
            this.execute(new FailureRunnable(t, this.callback));
        }
    }

    static class SuccessAction<E extends CDAResource>
    extends BaseAction<E> {
        SuccessAction(CDACallback<? extends CDAResource> callback, CDAClient client) {
            super(callback, client);
        }

        @Override
        protected void doCall(E e) {
            this.execute(new SuccessRunnable<E>(e, this.callback));
        }
    }

    static abstract class BaseAction<E>
    implements Action1<E> {
        protected final CDACallback<? extends CDAResource> callback;
        protected final CDAClient client;

        BaseAction(CDACallback<? extends CDAResource> callback, CDAClient client) {
            this.callback = callback;
            this.client = client;
        }

        public void call(E e) {
            if (!this.callback.isCancelled()) {
                this.doCall(e);
            }
            this.callback.unsubscribe();
        }

        protected abstract void doCall(E var1);

        protected void execute(Runnable r) {
            this.client.callbackExecutor.execute(r);
        }
    }
}

