/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.Keyword;
import com.cognitect.transit.Ratio;
import com.cognitect.transit.Symbol;
import com.cognitect.transit.TaggedValue;
import com.cognitect.transit.URI;
import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.Writer;
import com.cognitect.transit.impl.Cache;
import com.cognitect.transit.impl.JsonEmitter;
import com.cognitect.transit.impl.JsonVerboseEmitter;
import com.cognitect.transit.impl.LinkImpl;
import com.cognitect.transit.impl.MsgpackEmitter;
import com.cognitect.transit.impl.Quote;
import com.cognitect.transit.impl.WriteCache;
import com.cognitect.transit.impl.WriteHandlerMap;
import com.cognitect.transit.impl.WriteHandlers;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.msgpack.MessagePack;
import org.msgpack.packer.Packer;

public class WriterFactory {
    private static Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> newHandlerCache = new Cache();
    private static Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> newVerboseHandlerCache = new Cache();

    public static Map<Class, WriteHandler<?, ?>> defaultHandlers() {
        HashMap handlers = new HashMap();
        WriteHandlers.IntegerWriteHandler integerHandler = new WriteHandlers.IntegerWriteHandler();
        WriteHandlers.ToStringWriteHandler uriHandler = new WriteHandlers.ToStringWriteHandler("r");
        handlers.put(Boolean.class, new WriteHandlers.BooleanWriteHandler());
        handlers.put(null, new WriteHandlers.NullWriteHandler());
        handlers.put(String.class, new WriteHandlers.ToStringWriteHandler("s"));
        handlers.put(Integer.class, integerHandler);
        handlers.put(Long.class, integerHandler);
        handlers.put(Short.class, integerHandler);
        handlers.put(Byte.class, integerHandler);
        handlers.put(BigInteger.class, new WriteHandlers.ToStringWriteHandler("n"));
        handlers.put(Float.class, new WriteHandlers.FloatWriteHandler());
        handlers.put(Double.class, new WriteHandlers.DoubleWriteHandler());
        handlers.put(Map.class, new WriteHandlers.MapWriteHandler());
        handlers.put(BigDecimal.class, new WriteHandlers.ToStringWriteHandler("f"));
        handlers.put(Character.class, new WriteHandlers.ToStringWriteHandler("c"));
        handlers.put(Keyword.class, new WriteHandlers.KeywordWriteHandler());
        handlers.put(Symbol.class, new WriteHandlers.ToStringWriteHandler("$"));
        handlers.put(byte[].class, new WriteHandlers.BinaryWriteHandler());
        handlers.put(UUID.class, new WriteHandlers.UUIDWriteHandler());
        handlers.put(java.net.URI.class, uriHandler);
        handlers.put(URI.class, uriHandler);
        handlers.put(List.class, new WriteHandlers.ListWriteHandler());
        handlers.put(Object[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(int[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(long[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(float[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(double[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(short[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(boolean[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(char[].class, new WriteHandlers.ArrayWriteHandler());
        handlers.put(Set.class, new WriteHandlers.SetWriteHandler());
        handlers.put(Date.class, new WriteHandlers.TimeWriteHandler());
        handlers.put(Ratio.class, new WriteHandlers.RatioWriteHandler());
        handlers.put(LinkImpl.class, new WriteHandlers.LinkWriteHandler());
        handlers.put(Quote.class, new WriteHandlers.QuoteAbstractEmitter());
        handlers.put(TaggedValue.class, new WriteHandlers.TaggedValueWriteHandler());
        handlers.put(Object.class, new WriteHandlers.ObjectWriteHandler());
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WriteHandlerMap handlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        if (customHandlers instanceof WriteHandlerMap) {
            return (WriteHandlerMap)customHandlers;
        }
        if (newHandlerCache.containsKey(customHandlers)) {
            return newHandlerCache.get(customHandlers);
        }
        Class<WriterFactory> clazz = WriterFactory.class;
        synchronized (WriterFactory.class) {
            if (newHandlerCache.containsKey(customHandlers)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return newHandlerCache.get(customHandlers);
            }
            WriteHandlerMap writeHandlerMap = new WriteHandlerMap(customHandlers);
            newHandlerCache.put(customHandlers, writeHandlerMap);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return writeHandlerMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WriteHandlerMap verboseHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        if (customHandlers instanceof WriteHandlerMap) {
            return ((WriteHandlerMap)customHandlers).verboseWriteHandlerMap();
        }
        if (newVerboseHandlerCache.containsKey(customHandlers)) {
            return newVerboseHandlerCache.get(customHandlers);
        }
        Class<WriterFactory> clazz = WriterFactory.class;
        synchronized (WriterFactory.class) {
            if (newVerboseHandlerCache.containsKey(customHandlers)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return newVerboseHandlerCache.get(customHandlers);
            }
            WriteHandlerMap verboseHandlerMap = WriterFactory.handlerMap(customHandlers).verboseWriteHandlerMap();
            newVerboseHandlerCache.put(customHandlers, verboseHandlerMap);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return verboseHandlerMap;
        }
    }

    public static <T> Writer<T> getJsonInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, boolean verboseMode) throws IOException {
        JsonGenerator gen = new JsonFactory().createGenerator(out);
        final JsonEmitter emitter = verboseMode ? new JsonVerboseEmitter(gen, WriterFactory.verboseHandlerMap(customHandlers)) : new JsonEmitter(gen, WriterFactory.handlerMap(customHandlers));
        final WriteCache writeCache = new WriteCache(!verboseMode);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <T> Writer<T> getMsgpackInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers) throws IOException {
        Packer packer = new MessagePack().createPacker(out);
        final MsgpackEmitter emitter = new MsgpackEmitter(packer, WriterFactory.handlerMap(customHandlers));
        final WriteCache writeCache = new WriteCache(true);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

