/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit;

import com.cognitect.transit.DefaultReadHandler;
import com.cognitect.transit.Keyword;
import com.cognitect.transit.Link;
import com.cognitect.transit.ReadHandler;
import com.cognitect.transit.Reader;
import com.cognitect.transit.Symbol;
import com.cognitect.transit.TaggedValue;
import com.cognitect.transit.URI;
import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.Writer;
import com.cognitect.transit.impl.KeywordImpl;
import com.cognitect.transit.impl.LinkImpl;
import com.cognitect.transit.impl.ReadHandlerMap;
import com.cognitect.transit.impl.ReaderFactory;
import com.cognitect.transit.impl.SymbolImpl;
import com.cognitect.transit.impl.TaggedValueImpl;
import com.cognitect.transit.impl.URIImpl;
import com.cognitect.transit.impl.WriteHandlerMap;
import com.cognitect.transit.impl.WriterFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class TransitFactory {
    public static <T> Writer<T> writer(Format type, OutputStream out) {
        try {
            return TransitFactory.writer(type, out, null);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Writer<T> writer(Format type, OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers) {
        try {
            switch (type) {
                case MSGPACK: {
                    return WriterFactory.getMsgpackInstance(out, customHandlers);
                }
                case JSON: {
                    return WriterFactory.getJsonInstance(out, customHandlers, false);
                }
                case JSON_VERBOSE: {
                    return WriterFactory.getJsonInstance(out, customHandlers, true);
                }
            }
            throw new IllegalArgumentException("Unknown Writer type: " + type.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Reader reader(Format type, InputStream in) {
        return TransitFactory.reader(type, in, TransitFactory.defaultDefaultReadHandler());
    }

    public static Reader reader(Format type, InputStream in, Map<String, ReadHandler<?, ?>> customHandlers) {
        return TransitFactory.reader(type, in, customHandlers, null);
    }

    public static Reader reader(Format type, InputStream in, DefaultReadHandler<?> customDefaultHandler) {
        return TransitFactory.reader(type, in, null, customDefaultHandler);
    }

    public static Reader reader(Format type, InputStream in, Map<String, ReadHandler<?, ?>> customHandlers, DefaultReadHandler<?> customDefaultHandler) {
        try {
            switch (type) {
                case JSON: 
                case JSON_VERBOSE: {
                    return ReaderFactory.getJsonInstance(in, customHandlers, customDefaultHandler);
                }
                case MSGPACK: {
                    return ReaderFactory.getMsgpackInstance(in, customHandlers, customDefaultHandler);
                }
            }
            throw new IllegalArgumentException("Unknown Reader type: " + type.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Keyword keyword(Object o) {
        if (o instanceof Keyword) {
            return (Keyword)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.charAt(0) == ':') {
                return new KeywordImpl(s.substring(1));
            }
            return new KeywordImpl(s);
        }
        throw new IllegalArgumentException("Cannot make keyword from " + o.getClass().getSimpleName());
    }

    public static Symbol symbol(Object o) {
        if (o instanceof Symbol) {
            return (Symbol)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.charAt(0) == ':') {
                return new SymbolImpl(s.substring(1));
            }
            return new SymbolImpl(s);
        }
        throw new IllegalArgumentException("Cannot make symbol from " + o.getClass().getSimpleName());
    }

    public static <T> TaggedValue<T> taggedValue(String tag, T rep) {
        return new TaggedValueImpl<T>(tag, rep);
    }

    public static Link link(String href, String rel) {
        return TransitFactory.link(href, rel, null, null, null);
    }

    public static Link link(URI href, String rel) {
        return TransitFactory.link(href, rel, null, null, null);
    }

    public static Link link(String href, String rel, String name, String prompt, String render) {
        return TransitFactory.link(new URIImpl(href), rel, name, prompt, render);
    }

    public static Link link(URI href, String rel, String name, String prompt, String render) {
        return new LinkImpl(href, rel, name, prompt, render);
    }

    public static URI uri(String uri) {
        return new URIImpl(uri);
    }

    public static DefaultReadHandler<TaggedValue<Object>> defaultDefaultReadHandler() {
        return ReaderFactory.defaultDefaultHandler();
    }

    public static Map<String, ReadHandler<?, ?>> defaultReadHandlers() {
        return ReaderFactory.defaultHandlers();
    }

    public static Map<String, ReadHandler<?, ?>> readHandlerMap(Map<String, ReadHandler<?, ?>> customHandlers) {
        return new ReadHandlerMap(customHandlers);
    }

    public static Map<Class, WriteHandler<?, ?>> defaultWriteHandlers() {
        return WriterFactory.defaultHandlers();
    }

    public static Map<Class, WriteHandler<?, ?>> writeHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        return new WriteHandlerMap(customHandlers);
    }

    public static enum Format {
        JSON,
        MSGPACK,
        JSON_VERBOSE;

    }
}

