/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.parser;

import com.akiban.sql.parser.BooleanConstantNode;
import com.akiban.sql.parser.CharConstantNode;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.InsertNode;
import com.akiban.sql.parser.NumericConstantNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.RowResultSetNode;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.ValueNode;
import com.codoid.products.exception.FilloException;
import java.util.LinkedHashMap;
import java.util.Map;

public class InsertQueryParser {
    private String strQuery;
    private StatementNode stmt;
    private SQLParser parser;
    private RowResultSetNode rowResultSetNode;
    private InsertNode insertNode;

    public InsertQueryParser(String strQuery) {
        this.strQuery = strQuery;
        this.parser = new SQLParser();
    }

    public boolean initializeQuery() throws FilloException {
        boolean blResult = false;
        try {
            this.stmt = this.parser.parseStatement(this.strQuery);
            blResult = true;
        }
        catch (Exception e) {
            throw new FilloException("Invalid Query - " + this.strQuery);
        }
        return blResult;
    }

    public Map<String, String> getInsertColumnNamesAndValues() {
        LinkedHashMap<String, String> updateColumnNamesAndValuesMap = new LinkedHashMap<String, String>();
        try {
            int inColumnCounter = 0;
            String strValue = null;
            ResultColumnList columnList = this.insertNode.getTargetColumnList();
            for (ResultColumn f : this.rowResultSetNode.getResultColumns()) {
                ConstantNode charConstantNode;
                String strColumnName = ((ResultColumn)columnList.get(inColumnCounter)).getName().toUpperCase();
                ValueNode valueNode = f.getExpression();
                if (valueNode instanceof NumericConstantNode) {
                    NumericConstantNode numericConstantNode = (NumericConstantNode)valueNode;
                    strValue = numericConstantNode.getValue().toString();
                } else if (valueNode instanceof CharConstantNode) {
                    charConstantNode = (CharConstantNode)valueNode;
                    strValue = charConstantNode.getValue().toString().trim();
                } else if (valueNode instanceof BooleanConstantNode) {
                    charConstantNode = (BooleanConstantNode)valueNode;
                    strValue = charConstantNode.getValue().toString().trim();
                }
                updateColumnNamesAndValuesMap.put(strColumnName, strValue);
                ++inColumnCounter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updateColumnNamesAndValuesMap;
    }

    public String getTableName() {
        String strTableName = null;
        try {
            this.insertNode = (InsertNode)this.stmt;
            this.rowResultSetNode = (RowResultSetNode)this.insertNode.getResultSetNode();
            strTableName = this.insertNode.getTargetTableName().toString().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strTableName;
    }
}

