/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.parser;

import com.akiban.sql.parser.AndNode;
import com.akiban.sql.parser.BinaryOperatorNode;
import com.akiban.sql.parser.BooleanConstantNode;
import com.akiban.sql.parser.CharConstantNode;
import com.akiban.sql.parser.ColumnReference;
import com.akiban.sql.parser.DeleteNode;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.LikeEscapeOperatorNode;
import com.akiban.sql.parser.NumericConstantNode;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.ValueNode;
import com.codoid.products.exception.FilloException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteQueryParser {
    private String strQuery;
    private StatementNode stmt;
    private SQLParser parser;
    private Object whereNode;
    private SelectNode selectNode;
    private DeleteNode deleteNode;
    private String strWhereValueType;
    private int inWhereConditionCounter = 0;
    private Map<String, Map<String, String>> whereConditionsMap;

    public DeleteQueryParser(String strQuery) {
        this.strQuery = strQuery;
        this.parser = new SQLParser();
        this.whereConditionsMap = new LinkedHashMap<String, Map<String, String>>();
    }

    public boolean initializeQuery() throws FilloException {
        boolean blResult = false;
        try {
            this.stmt = this.parser.parseStatement(this.strQuery);
            blResult = true;
        }
        catch (Exception e) {
            throw new FilloException("Invalid Query - " + this.strQuery);
        }
        return blResult;
    }

    public String getTableName() {
        String strTableName = null;
        this.deleteNode = (DeleteNode)this.stmt;
        this.selectNode = (SelectNode)this.deleteNode.getResultSetNode();
        try {
            strTableName = ((FromTable)this.selectNode.getFromList().get(0)).getTableName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strTableName;
    }

    public Map<String, Map<String, String>> getAllWhereDetails() {
        try {
            this.getNodeDetails(this.whereNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.whereConditionsMap;
    }

    private void getNodeDetails(Object node) {
        if (node instanceof AndNode) {
            this.getNodeDetails(((BinaryOperatorNode)node).getLeftOperand());
            this.getNodeDetails(((BinaryOperatorNode)node).getRightOperand());
        } else if (node instanceof BinaryOperatorNode) {
            HashMap<String, String> whereBinary = new HashMap<String, String>();
            whereBinary.put("WHERE_VALUE", this.getWhereValue((BinaryOperatorNode)node));
            whereBinary.put("WHERE_COLUMN", this.getWhereColumn((BinaryOperatorNode)node));
            whereBinary.put("WHERE_OPERATOR", this.getWhereOperator((BinaryOperatorNode)node));
            this.whereConditionsMap.put("" + this.inWhereConditionCounter, whereBinary);
            ++this.inWhereConditionCounter;
        } else if (node instanceof LikeEscapeOperatorNode) {
            HashMap<String, String> whereLike = new HashMap<String, String>();
            whereLike.put("WHERE_VALUE", this.getWhereValue((LikeEscapeOperatorNode)node));
            whereLike.put("WHERE_COLUMN", this.getLikeEscapeOperatorColumn((LikeEscapeOperatorNode)node));
            whereLike.put("WHERE_OPERATOR", this.getWhereOperator((LikeEscapeOperatorNode)node));
            this.whereConditionsMap.put("" + this.inWhereConditionCounter, whereLike);
            ++this.inWhereConditionCounter;
        }
    }

    public boolean isWherePresent() {
        boolean blResult = false;
        try {
            this.whereNode = this.selectNode.getWhereClause();
            blResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public String getWhereColumn() {
        String strWhereColumnName = "";
        try {
            ColumnReference columnReference = (ColumnReference)((BinaryOperatorNode)this.whereNode).getLeftOperand();
            strWhereColumnName = columnReference.getColumnName().trim().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereColumnName;
    }

    public String getWhereValue() {
        String strWhereValue = "";
        try {
            ValueNode valueNode = ((BinaryOperatorNode)this.whereNode).getRightOperand();
            if (valueNode instanceof CharConstantNode) {
                CharConstantNode charConstantNode = (CharConstantNode)valueNode;
                strWhereValue = charConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            } else if (valueNode instanceof NumericConstantNode) {
                NumericConstantNode numericConstantNode = (NumericConstantNode)valueNode;
                strWhereValue = numericConstantNode.getValue().toString();
                this.strWhereValueType = "NUMERIC";
            } else if (valueNode instanceof BooleanConstantNode) {
                BooleanConstantNode booleanConstantNode = (BooleanConstantNode)valueNode;
                strWhereValue = booleanConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereValue;
    }

    public String getWhereValueType() {
        return this.strWhereValueType;
    }

    public String getWhereOperator(BinaryOperatorNode whereNode) {
        return whereNode.getOperator().toString().trim();
    }

    public String getWhereOperator(LikeEscapeOperatorNode whereNode) {
        return whereNode.getOperator().toString().trim();
    }

    public String getWhereOperator() {
        return ((BinaryOperatorNode)this.whereNode).getOperator().toString().trim();
    }

    public String getWhereValue(BinaryOperatorNode whereNode) {
        String strWhereValue = "";
        try {
            ValueNode valueNode = whereNode.getRightOperand();
            if (valueNode instanceof CharConstantNode) {
                CharConstantNode charConstantNode = (CharConstantNode)valueNode;
                strWhereValue = charConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            } else if (valueNode instanceof NumericConstantNode) {
                NumericConstantNode numericConstantNode = (NumericConstantNode)valueNode;
                strWhereValue = numericConstantNode.getValue().toString();
                this.strWhereValueType = "NUMERIC";
            } else if (valueNode instanceof BooleanConstantNode) {
                BooleanConstantNode booleanConstantNode = (BooleanConstantNode)valueNode;
                strWhereValue = booleanConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereValue;
    }

    public String getWhereColumn(BinaryOperatorNode whereNode) {
        String strWhereColumnName = "";
        try {
            ValueNode valueNode = whereNode.getLeftOperand();
            ColumnReference columnReference = (ColumnReference)valueNode;
            strWhereColumnName = columnReference.getColumnName().trim().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereColumnName;
    }

    public String getLikeEscapeOperatorColumn(LikeEscapeOperatorNode whereNode) {
        String strWhereColumnName = "";
        try {
            ValueNode valueNode = whereNode.getReceiver();
            ColumnReference columnReference = (ColumnReference)valueNode;
            strWhereColumnName = columnReference.getColumnName().trim().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereColumnName;
    }

    public String getWhereValue(LikeEscapeOperatorNode whereNode) {
        String strWhereValue = "";
        try {
            ValueNode valueNode = whereNode.getLeftOperand();
            if (valueNode instanceof CharConstantNode) {
                CharConstantNode charConstantNode = (CharConstantNode)valueNode;
                strWhereValue = charConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            } else if (valueNode instanceof NumericConstantNode) {
                NumericConstantNode numericConstantNode = (NumericConstantNode)valueNode;
                strWhereValue = numericConstantNode.getValue().toString();
                this.strWhereValueType = "NUMERIC";
            } else if (valueNode instanceof BooleanConstantNode) {
                BooleanConstantNode booleanConstantNode = (BooleanConstantNode)valueNode;
                strWhereValue = booleanConstantNode.getValue().toString();
                this.strWhereValueType = "STRING";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strWhereValue;
    }
}

