/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.unparser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.AggregateNode;
import com.akiban.sql.parser.AggregateWindowFunctionNode;
import com.akiban.sql.parser.AllResultColumn;
import com.akiban.sql.parser.BetweenOperatorNode;
import com.akiban.sql.parser.BinaryArithmeticOperatorNode;
import com.akiban.sql.parser.BinaryBitOperatorNode;
import com.akiban.sql.parser.BinaryComparisonOperatorNode;
import com.akiban.sql.parser.BinaryLogicalOperatorNode;
import com.akiban.sql.parser.BinaryOperatorNode;
import com.akiban.sql.parser.BooleanConstantNode;
import com.akiban.sql.parser.CallStatementNode;
import com.akiban.sql.parser.CastNode;
import com.akiban.sql.parser.CloseStatementNode;
import com.akiban.sql.parser.CoalesceFunctionNode;
import com.akiban.sql.parser.ColumnDefinitionNode;
import com.akiban.sql.parser.ColumnReference;
import com.akiban.sql.parser.ConcatenationOperatorNode;
import com.akiban.sql.parser.ConditionalNode;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.ConstraintDefinitionNode;
import com.akiban.sql.parser.CopyStatementNode;
import com.akiban.sql.parser.CreateAliasNode;
import com.akiban.sql.parser.CreateIndexNode;
import com.akiban.sql.parser.CreateTableNode;
import com.akiban.sql.parser.CreateViewNode;
import com.akiban.sql.parser.CurrentDatetimeOperatorNode;
import com.akiban.sql.parser.CurrentSequenceNode;
import com.akiban.sql.parser.CursorNode;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.DeallocateStatementNode;
import com.akiban.sql.parser.DeclareStatementNode;
import com.akiban.sql.parser.DeleteNode;
import com.akiban.sql.parser.DropIndexNode;
import com.akiban.sql.parser.ExecuteStatementNode;
import com.akiban.sql.parser.ExplainStatementNode;
import com.akiban.sql.parser.ExplicitCollateNode;
import com.akiban.sql.parser.ExtractOperatorNode;
import com.akiban.sql.parser.FKConstraintDefinitionNode;
import com.akiban.sql.parser.FetchStatementNode;
import com.akiban.sql.parser.FromBaseTable;
import com.akiban.sql.parser.FromList;
import com.akiban.sql.parser.FromSubquery;
import com.akiban.sql.parser.FullOuterJoinNode;
import com.akiban.sql.parser.GroupByColumn;
import com.akiban.sql.parser.GroupByList;
import com.akiban.sql.parser.GroupConcatNode;
import com.akiban.sql.parser.HalfOuterJoinNode;
import com.akiban.sql.parser.InListOperatorNode;
import com.akiban.sql.parser.IndexColumn;
import com.akiban.sql.parser.IndexColumnList;
import com.akiban.sql.parser.IndexConstraintDefinitionNode;
import com.akiban.sql.parser.InsertNode;
import com.akiban.sql.parser.IsNode;
import com.akiban.sql.parser.IsNullNode;
import com.akiban.sql.parser.JavaToSQLValueNode;
import com.akiban.sql.parser.JavaValueNode;
import com.akiban.sql.parser.JoinNode;
import com.akiban.sql.parser.LeftRightFuncOperatorNode;
import com.akiban.sql.parser.LengthOperatorNode;
import com.akiban.sql.parser.LikeEscapeOperatorNode;
import com.akiban.sql.parser.NextSequenceNode;
import com.akiban.sql.parser.NotNode;
import com.akiban.sql.parser.OctetLengthOperatorNode;
import com.akiban.sql.parser.OrderByColumn;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.ParameterNode;
import com.akiban.sql.parser.PartitionByColumn;
import com.akiban.sql.parser.PartitionByList;
import com.akiban.sql.parser.PrepareStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.QueryTreeNodeList;
import com.akiban.sql.parser.RenameNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.RowNumberFunctionNode;
import com.akiban.sql.parser.RowResultSetNode;
import com.akiban.sql.parser.RowsResultSetNode;
import com.akiban.sql.parser.SQLToJavaValueNode;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.SetConfigurationNode;
import com.akiban.sql.parser.SetTransactionAccessNode;
import com.akiban.sql.parser.SetTransactionIsolationNode;
import com.akiban.sql.parser.SimpleCaseNode;
import com.akiban.sql.parser.SimpleStringOperatorNode;
import com.akiban.sql.parser.StaticMethodCallNode;
import com.akiban.sql.parser.StorageLocation;
import com.akiban.sql.parser.SubqueryNode;
import com.akiban.sql.parser.TableElementList;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.TernaryOperatorNode;
import com.akiban.sql.parser.TimestampOperatorNode;
import com.akiban.sql.parser.TransactionControlNode;
import com.akiban.sql.parser.TrimOperatorNode;
import com.akiban.sql.parser.UnaryArithmeticOperatorNode;
import com.akiban.sql.parser.UnaryBitOperatorNode;
import com.akiban.sql.parser.UnaryDateTimestampOperatorNode;
import com.akiban.sql.parser.UnaryOperatorNode;
import com.akiban.sql.parser.UnionNode;
import com.akiban.sql.parser.UpdateNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.VirtualColumnNode;
import com.akiban.sql.parser.WindowDefinitionNode;
import com.akiban.sql.parser.WindowList;
import com.akiban.sql.parser.WindowReferenceNode;

public class NodeToString {
    public String toString(QueryTreeNode node) throws StandardException {
        switch (node.getNodeType()) {
            case 141: {
                return this.createTableNode((CreateTableNode)node);
            }
            case 130: {
                return this.createViewNode((CreateViewNode)node);
            }
            case 65: 
            case 91: 
            case 92: {
                return this.qualifiedDDLNode((DDLStatementNode)node);
            }
            case 63: {
                return this.dropIndexNode((DropIndexNode)node);
            }
            case 117: {
                return this.explainStatementNode((ExplainStatementNode)node);
            }
            case 197: {
                return this.transactionControlNode((TransactionControlNode)node);
            }
            case 21: {
                return this.setTransactionIsolationNode((SetTransactionIsolationNode)node);
            }
            case 22: {
                return this.setTransactionAccessNode((SetTransactionAccessNode)node);
            }
            case 27: {
                return this.setConfigurationNode((SetConfigurationNode)node);
            }
            case 12: {
                return this.tableElementList((TableElementList)node);
            }
            case 116: {
                return this.columnDefinitionNode((ColumnDefinitionNode)node);
            }
            case 131: {
                return this.constraintDefinitionNode((ConstraintDefinitionNode)node);
            }
            case 119: {
                return this.fkConstraintDefinitionNode((FKConstraintDefinitionNode)node);
            }
            case 146: {
                return this.createIndexNode((CreateIndexNode)node);
            }
            case 17: {
                return this.indexColumnList((IndexColumnList)node);
            }
            case 10: {
                return this.indexColumn((IndexColumn)node);
            }
            case 150: {
                return this.createAliasNode((CreateAliasNode)node);
            }
            case 191: {
                return this.renameNode((RenameNode)node);
            }
            case 147: {
                return this.cursorNode((CursorNode)node);
            }
            case 129: {
                return this.selectNode((SelectNode)node);
            }
            case 138: {
                return this.insertNode((InsertNode)node);
            }
            case 102: {
                return this.updateNode((UpdateNode)node);
            }
            case 101: {
                return this.deleteNode((DeleteNode)node);
            }
            case 93: {
                return this.subqueryNode((SubqueryNode)node);
            }
            case 9: {
                return this.resultColumnList((ResultColumnList)node);
            }
            case 80: {
                return this.resultColumn((ResultColumn)node);
            }
            case 16: {
                return this.allResultColumn((AllResultColumn)node);
            }
            case 37: {
                return this.fromList((FromList)node);
            }
            case 139: 
            case 144: 
            case 173: {
                return this.joinNode((JoinNode)node);
            }
            case 142: {
                return this.unionNode((UnionNode)node);
            }
            case 3: {
                return this.groupByList((GroupByList)node);
            }
            case 167: {
                return this.groupConcat((GroupConcatNode)node);
            }
            case 7: {
                return this.orderByList((OrderByList)node);
            }
            case 15: {
                return this.valueNodeList((ValueNodeList)node);
            }
            case 135: {
                return this.fromBaseTable((FromBaseTable)node);
            }
            case 136: {
                return this.fromSubquery((FromSubquery)node);
            }
            case 34: {
                return this.tableName((TableName)node);
            }
            case 62: {
                return this.columnReference((ColumnReference)node);
            }
            case 107: {
                return this.virtualColumnNode((VirtualColumnNode)node);
            }
            case 105: {
                return this.rowResultSetNode((RowResultSetNode)node);
            }
            case 160: {
                return this.rowsResultSetNode((RowsResultSetNode)node);
            }
            case 35: {
                return this.groupByColumn((GroupByColumn)node);
            }
            case 104: {
                return this.orderByColumn((OrderByColumn)node);
            }
            case 171: {
                return this.partitionByList((PartitionByList)node);
            }
            case 172: {
                return this.partitionByColumn((PartitionByColumn)node);
            }
            case 228: {
                return this.windowDefinitionNode((WindowDefinitionNode)node);
            }
            case 229: {
                return this.windowReferenceNode((WindowReferenceNode)node);
            }
            case 226: {
                return this.aggregateWindowFunctionNode((AggregateWindowFunctionNode)node);
            }
            case 227: {
                return this.rowNumberFunctionNode((RowNumberFunctionNode)node);
            }
            case 39: 
            case 52: {
                return this.binaryLogicalOperatorNode((BinaryLogicalOperatorNode)node);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                return this.binaryComparisonOperatorNode((BinaryComparisonOperatorNode)node);
            }
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 79: 
            case 194: {
                return this.binaryArithmeticOperatorNode((BinaryArithmeticOperatorNode)node);
            }
            case 66: {
                return this.binaryBitOperatorNode((BinaryBitOperatorNode)node);
            }
            case 50: {
                return this.concatenationOperatorNode((ConcatenationOperatorNode)node);
            }
            case 26: {
                return this.notNode((NotNode)node);
            }
            case 24: 
            case 25: {
                return this.isNullNode((IsNullNode)node);
            }
            case 111: {
                return this.isNode((IsNode)node);
            }
            case 188: 
            case 189: {
                return this.unaryArithmeticOperatorNode((UnaryArithmeticOperatorNode)node);
            }
            case 29: 
            case 30: {
                return this.unaryPrefixOperatorNode((UnaryArithmeticOperatorNode)node);
            }
            case 64: {
                return this.unaryBitOperatorNode((UnaryBitOperatorNode)node);
            }
            case 32: {
                return this.unaryDateTimestampOperatorNode((UnaryDateTimestampOperatorNode)node);
            }
            case 33: {
                return this.timestampOperatorNode((TimestampOperatorNode)node);
            }
            case 87: {
                return this.extractOperatorNode((ExtractOperatorNode)node);
            }
            case 23: {
                return this.lengthOperatorNode((LengthOperatorNode)node);
            }
            case 20: {
                return this.octetLengthOperatorNode((OctetLengthOperatorNode)node);
            }
            case 158: 
            case 159: {
                return this.leftRightFuncOperatorNode((LeftRightFuncOperatorNode)node);
            }
            case 83: {
                return this.simpleStringOperatorNode((SimpleStringOperatorNode)node);
            }
            case 51: {
                return this.likeEscapeOperatorNode((LikeEscapeOperatorNode)node);
            }
            case 154: 
            case 190: {
                return this.ternaryOperatorNode((TernaryOperatorNode)node);
            }
            case 184: 
            case 185: {
                return this.timestampFunctionNode((TernaryOperatorNode)node);
            }
            case 127: {
                return this.trimOperatorNode((TrimOperatorNode)node);
            }
            case 55: {
                return this.inListOperatorNode((InListOperatorNode)node);
            }
            case 166: {
                return this.rowCtorNode((RowConstructorNode)node);
            }
            case 53: {
                return this.betweenOperatorNode((BetweenOperatorNode)node);
            }
            case 54: {
                return this.conditionalNode((ConditionalNode)node);
            }
            case 170: {
                return this.simpleCaseNode((SimpleCaseNode)node);
            }
            case 192: {
                return this.coalesceFunctionNode((CoalesceFunctionNode)node);
            }
            case 115: {
                return this.aggregateNode((AggregateNode)node);
            }
            case 13: 
            case 31: 
            case 38: 
            case 58: 
            case 59: 
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 195: 
            case 196: 
            case 199: {
                return this.constantNode((ConstantNode)node);
            }
            case 88: {
                return this.parameterNode((ParameterNode)node);
            }
            case 100: {
                return "DEFAULT";
            }
            case 110: {
                return "USER";
            }
            case 109: {
                return "CURRENT_USER";
            }
            case 125: {
                return "SESSION_USER";
            }
            case 126: {
                return "SYSTEM_USER";
            }
            case 4: {
                return "CURRENT ISOLATION";
            }
            case 5: {
                return "IDENTITY_VAL_LOCAL()";
            }
            case 6: {
                return "CURRENT SCHEMA";
            }
            case 210: {
                return "CURRENT_ROLE";
            }
            case 108: {
                return this.currentDatetimeOperatorNode((CurrentDatetimeOperatorNode)node);
            }
            case 60: {
                return this.castNode((CastNode)node);
            }
            case 145: {
                return this.explicitCollateNode((ExplicitCollateNode)node);
            }
            case 231: {
                return this.nextSequenceNode((NextSequenceNode)node);
            }
            case 232: {
                return this.currentSequenceNode((CurrentSequenceNode)node);
            }
            case 36: {
                return this.javaToSQLValueNode((JavaToSQLValueNode)node);
            }
            case 28: {
                return this.sqlToJavaValueNode((SQLToJavaValueNode)node);
            }
            case 85: {
                return this.staticMethodCallNode((StaticMethodCallNode)node);
            }
            case 95: {
                return this.callStatementNode((CallStatementNode)node);
            }
            case 164: {
                return this.indexConstraint((IndexConstraintDefinitionNode)node);
            }
            case 233: {
                return this.declareStatementNode((DeclareStatementNode)node);
            }
            case 234: {
                return this.fetchStatementNode((FetchStatementNode)node);
            }
            case 235: {
                return this.closeStatementNode((CloseStatementNode)node);
            }
            case 236: {
                return this.prepareStatementNode((PrepareStatementNode)node);
            }
            case 237: {
                return this.executeStatementNode((ExecuteStatementNode)node);
            }
            case 238: {
                return this.deallocateStatementNode((DeallocateStatementNode)node);
            }
            case 118: {
                return this.copyStatementNode((CopyStatementNode)node);
            }
        }
        return "**UNKNOWN(" + node.getNodeType() + ")**";
    }

    protected String indexConstraint(IndexConstraintDefinitionNode node) throws StandardException {
        StringBuilder builder = new StringBuilder("INDEX ");
        String indexName = node.getIndexName();
        if (indexName != null) {
            builder.append(indexName).append(' ');
        }
        builder.append('(').append(this.indexColumnList(node.getIndexColumnList())).append(')');
        StorageLocation loc = node.getLocation();
        if (loc != null) {
            builder.append(" AS ").append((Object)loc);
        }
        return builder.toString();
    }

    protected String createTableNode(CreateTableNode node) throws StandardException {
        StringBuilder str = new StringBuilder("CREATE TABLE ");
        str.append(this.toString(node.getObjectName()));
        if (node.getTableElementList() != null) {
            str.append("(");
            str.append(this.toString(node.getTableElementList()));
            str.append(")");
        }
        if (node.getQueryExpression() != null) {
            str.append(" AS (");
            str.append(this.toString(node.getQueryExpression()));
            str.append(") WITH ");
            if (!node.isWithData()) {
                str.append("NO ");
            }
            str.append("DATA");
        }
        return str.toString();
    }

    protected String createViewNode(CreateViewNode node) throws StandardException {
        StringBuilder str = new StringBuilder("CREATE VIEW ");
        str.append(this.toString(node.getObjectName()));
        if (node.getResultColumns() != null) {
            str.append("(");
            str.append(this.toString(node.getResultColumns()));
            str.append(")");
        }
        str.append(" AS (");
        str.append(this.toString(node.getParsedQueryExpression()));
        str.append(")");
        return str.toString();
    }

    protected String tableElementList(TableElementList node) throws StandardException {
        return this.nodeList(node);
    }

    protected String columnDefinitionNode(ColumnDefinitionNode node) throws StandardException {
        return node.getColumnName() + " " + node.getType();
    }

    protected String constraintDefinitionNode(ConstraintDefinitionNode node) throws StandardException {
        switch (node.getConstraintType()) {
            case PRIMARY_KEY: {
                return "PRIMARY KEY(" + this.toString(node.getColumnList()) + ")";
            }
            case UNIQUE: {
                return "UNIQUE(" + this.toString(node.getColumnList()) + ")";
            }
        }
        return "**UNKNOWN(" + (Object)((Object)node.getConstraintType()) + ")";
    }

    protected String fkConstraintDefinitionNode(FKConstraintDefinitionNode node) throws StandardException {
        StringBuilder str = new StringBuilder();
        if (node.isGrouping()) {
            str.append("GROUPING ");
        }
        str.append("FOREIGN KEY(");
        str.append(this.toString(node.getColumnList()));
        str.append(") REFERENCES ");
        str.append(this.toString(node.getRefTableName()));
        str.append("(");
        str.append(this.toString(node.getColumnList()));
        str.append(")");
        return str.toString();
    }

    protected String createIndexNode(CreateIndexNode node) throws StandardException {
        StringBuilder str = new StringBuilder("CREATE ");
        if (node.getUniqueness()) {
            str.append("UNIQUE ");
        }
        str.append("INDEX");
        str.append(" ");
        switch (node.getExistenceCheck()) {
            case IF_EXISTS: {
                str.append("IF EXISTS ");
                break;
            }
            case IF_NOT_EXISTS: {
                str.append("IF NOT EXISTS ");
            }
        }
        str.append(this.toString(node.getIndexName()));
        str.append(" ON ");
        str.append(node.getIndexTableName());
        str.append("(");
        str.append(this.toString(node.getColumnList()));
        str.append(")");
        if (node.getJoinType() != null) {
            str.append(String.format(" USING %s JOIN", node.getJoinType() == JoinNode.JoinType.LEFT_OUTER ? "LEFT" : "RIGHT"));
        }
        return str.toString();
    }

    protected String indexColumnList(IndexColumnList node) throws StandardException {
        StringBuilder buffer = new StringBuilder();
        int firstFunctionArg = node.firstFunctionArg();
        int lastFunctionArg = node.lastFunctionArg();
        for (int arg = 0; arg < node.size(); ++arg) {
            if (arg > 0) {
                buffer.append(", ");
            }
            if (arg == firstFunctionArg) {
                buffer.append((Object)node.functionType());
                buffer.append('(');
            }
            buffer.append(this.toString((QueryTreeNode)node.get(arg)));
            if (arg != lastFunctionArg) continue;
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String indexColumn(IndexColumn node) throws StandardException {
        StringBuilder str = new StringBuilder();
        if (node.getTableName() != null) {
            str.append(this.toString(node.getTableName()));
            str.append(".");
        }
        str.append(node.getColumnName());
        if (!node.isAscending()) {
            str.append(" DESC");
        }
        return str.toString();
    }

    protected String createAliasNode(CreateAliasNode node) throws StandardException {
        StringBuilder str = new StringBuilder(node.statementToString());
        if (node.isCreateOrReplace()) {
            str.insert(6, " OR REPLACE");
        }
        str.append(' ');
        str.append(this.toString(node.getObjectName()));
        switch (node.getAliasType()) {
            case PROCEDURE: 
            case FUNCTION: {
                str.append(node.getAliasInfo());
                if (node.getDefinition() != null) {
                    str.append(" AS '");
                    if (node.getDefinition().indexOf(10) >= 0) {
                        str.append("$$");
                        str.append(node.getDefinition());
                        str.append("$$");
                    } else {
                        str.append(node.getDefinition().replace("'", "''"));
                    }
                    str.append('\'');
                    break;
                }
                str.append(" EXTERNAL NAME '");
                str.append(node.getJavaClassName());
                if (node.getMethodName() != null) {
                    str.append('.');
                    str.append(node.getMethodName());
                }
                str.append('\'');
            }
        }
        return str.toString();
    }

    protected String renameNode(RenameNode node) throws StandardException {
        if (node.isAlterTable()) {
            return "ALTER TABLE " + this.toString(node.getObjectName()) + "RENAME COLUMN " + node.getOldObjectName() + " TO " + node.getNewObjectName();
        }
        if (node.getRenameType() == RenameNode.RenameType.INDEX || node.getRenameType() == RenameNode.RenameType.COLUMN) {
            if (node.getObjectName() == null) {
                return node.statementToString() + " " + node.getOldObjectName() + " TO " + node.getNewObjectName();
            }
            return node.statementToString() + " " + this.toString(node.getObjectName()) + "." + node.getOldObjectName() + " TO " + node.getNewObjectName();
        }
        return node.statementToString() + " " + this.toString(node.getObjectName()) + " TO " + this.toString(node.getNewTableName());
    }

    protected String dropIndexNode(DropIndexNode node) throws StandardException {
        StringBuilder str = new StringBuilder(node.statementToString());
        str.append(" ");
        if (node.getObjectName() != null) {
            str.append(this.toString(node.getObjectName()));
            str.append(".");
        }
        str.append(node.getIndexName());
        return str.toString();
    }

    protected String cursorNode(CursorNode node) throws StandardException {
        String result = this.toString(node.getResultSetNode());
        if (node.getOrderByList() != null) {
            result = result + " " + this.toString(node.getOrderByList());
        }
        if (node.getFetchFirstClause() != null) {
            result = result + " LIMIT " + this.toString(node.getFetchFirstClause());
        }
        if (node.getOffsetClause() != null) {
            result = result + " OFFSET " + this.toString(node.getOffsetClause());
        }
        return result;
    }

    protected String selectNode(SelectNode node) throws StandardException {
        StringBuilder str = new StringBuilder("SELECT ");
        if (node.isDistinct()) {
            str.append("DISTINCT ");
        }
        str.append(this.toString(node.getResultColumns()));
        if (!node.getFromList().isEmpty()) {
            str.append(" FROM ");
            str.append(this.toString(node.getFromList()));
        }
        if (node.getWhereClause() != null) {
            str.append(" WHERE ");
            str.append(this.toString(node.getWhereClause()));
        }
        if (node.getGroupByList() != null) {
            str.append(" ");
            str.append(this.toString(node.getGroupByList()));
        }
        if (node.getHavingClause() != null) {
            str.append(" HAVING ");
            str.append(this.toString(node.getHavingClause()));
        }
        if (node.getWindows() != null) {
            str.append(" ");
            str.append(this.windowList(node.getWindows()));
        }
        return str.toString();
    }

    protected String insertNode(InsertNode node) throws StandardException {
        StringBuilder str = new StringBuilder("INSERT INTO ");
        str.append(this.toString(node.getTargetTableName()));
        if (node.getTargetColumnList() != null) {
            str.append("(");
            str.append(this.toString(node.getTargetColumnList()));
            str.append(")");
        }
        str.append(" ");
        str.append(this.toString(node.getResultSetNode()));
        if (node.getOrderByList() != null) {
            str.append(" ");
            str.append(this.toString(node.getOrderByList()));
        }
        if (node.getReturningList() != null) {
            str.append(" RETURNING ");
            str.append(this.toString(node.getReturningList()));
        }
        return str.toString();
    }

    protected String updateNode(UpdateNode unode) throws StandardException {
        SelectNode snode = (SelectNode)unode.getResultSetNode();
        StringBuilder str = new StringBuilder("UPDATE ");
        str.append(this.toString((QueryTreeNode)snode.getFromList().get(0)));
        str.append(" SET ");
        boolean first = true;
        for (ResultColumn col : snode.getResultColumns()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(this.toString(col.getReference()));
            str.append(" = ");
            str.append(this.maybeParens(col.getExpression()));
        }
        if (snode.getWhereClause() != null) {
            str.append(" WHERE ");
            str.append(this.toString(snode.getWhereClause()));
        }
        if (unode.getReturningList() != null) {
            str.append(" RETURNING ");
            str.append(this.toString(unode.getReturningList()));
        }
        return str.toString();
    }

    protected String deleteNode(DeleteNode dnode) throws StandardException {
        SelectNode snode = (SelectNode)dnode.getResultSetNode();
        StringBuilder str = new StringBuilder("DELETE FROM ");
        str.append(this.toString((QueryTreeNode)snode.getFromList().get(0)));
        if (snode.getWhereClause() != null) {
            str.append(" WHERE ");
            str.append(this.toString(snode.getWhereClause()));
        }
        if (dnode.getReturningList() != null) {
            str.append(" RETURNING ");
            str.append(this.toString(dnode.getReturningList()));
        }
        return str.toString();
    }

    protected String subqueryNode(SubqueryNode node) throws StandardException {
        String str = this.toString(node.getResultSet());
        if (node.getOrderByList() != null) {
            str = str + " " + this.toString(node.getOrderByList());
        }
        str = "(" + str + ")";
        switch (node.getSubqueryType()) {
            default: {
                return str;
            }
            case EXISTS: {
                return "EXISTS " + str;
            }
            case NOT_EXISTS: {
                return "NOT EXISTS " + str;
            }
            case IN: {
                return this.maybeParens(node.getLeftOperand()) + " IN " + str;
            }
            case NOT_IN: {
                return this.maybeParens(node.getLeftOperand()) + " NOT IN " + str;
            }
            case EQ_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " = ANY " + str;
            }
            case EQ_ALL: {
                return this.maybeParens(node.getLeftOperand()) + " = ALL " + str;
            }
            case NE_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " <> ANY " + str;
            }
            case NE_ALL: {
                return this.maybeParens(node.getLeftOperand()) + " <> ALL " + str;
            }
            case GT_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " > ANY " + str;
            }
            case GT_ALL: {
                return this.maybeParens(node.getLeftOperand()) + " > ALL " + str;
            }
            case GE_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " >= ANY " + str;
            }
            case GE_ALL: {
                return this.maybeParens(node.getLeftOperand()) + " > ANY " + str;
            }
            case LT_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " < ANY " + str;
            }
            case LT_ALL: {
                return this.maybeParens(node.getLeftOperand()) + " < ALL " + str;
            }
            case LE_ANY: {
                return this.maybeParens(node.getLeftOperand()) + " <= ANY " + str;
            }
            case LE_ALL: 
        }
        return this.maybeParens(node.getLeftOperand()) + " <= ALL " + str;
    }

    protected String rowResultSetNode(RowResultSetNode node) throws StandardException {
        return "VALUES(" + this.toString(node.getResultColumns()) + ")";
    }

    protected String rowsResultSetNode(RowsResultSetNode node) throws StandardException {
        StringBuilder str = new StringBuilder("VALUES");
        boolean first = true;
        for (RowResultSetNode row : node.getRows()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append("(");
            str.append(this.toString(row.getResultColumns()));
            str.append(")");
        }
        return str.toString();
    }

    protected String resultColumnList(ResultColumnList node) throws StandardException {
        return this.nodeList(node);
    }

    protected String resultColumn(ResultColumn node) throws StandardException {
        if (node.getReference() != null) {
            return this.toString(node.getReference());
        }
        String n = node.getName();
        if (node.getExpression() == null) {
            return n;
        }
        String x = this.maybeParens(node.getExpression());
        if (n == null || n.equals(x)) {
            return x;
        }
        return x + " AS " + n;
    }

    protected String allResultColumn(AllResultColumn node) throws StandardException {
        return "*";
    }

    protected String fromList(FromList node) throws StandardException {
        return this.nodeList(node);
    }

    protected String fromBaseTable(FromBaseTable node) throws StandardException {
        String tn = this.toString(node.getOrigTableName());
        String n = node.getCorrelationName();
        if (n == null) {
            return tn;
        }
        return tn + " AS " + n;
    }

    protected String fromSubquery(FromSubquery node) throws StandardException {
        StringBuilder str = new StringBuilder(this.toString(node.getSubquery()));
        if (node.getOrderByList() != null) {
            str.append(' ');
            str.append(this.toString(node.getOrderByList()));
        }
        str.insert(0, '(');
        str.append(')');
        str.append(" AS ");
        str.append(node.getCorrelationName());
        if (node.getResultColumns() != null) {
            str.append('(');
            str.append(this.toString(node.getResultColumns()));
            str.append(')');
        }
        return str.toString();
    }

    protected String joinNode(JoinNode node) throws StandardException {
        StringBuilder str = new StringBuilder(this.toString(node.getLeftResultSet()));
        JoinNode.JoinType joinType = JoinNode.JoinType.INNER;
        if (node instanceof HalfOuterJoinNode) {
            joinType = ((HalfOuterJoinNode)node).isRightOuterJoin() ? JoinNode.JoinType.RIGHT_OUTER : JoinNode.JoinType.LEFT_OUTER;
        } else if (node instanceof FullOuterJoinNode) {
            joinType = JoinNode.JoinType.FULL_OUTER;
        }
        str.append(' ');
        if (node.isNaturalJoin()) {
            str.append("NATURAL ");
        }
        str.append(JoinNode.joinTypeToString(joinType));
        str.append(' ');
        str.append(this.toString(node.getRightResultSet()));
        if (node.getJoinClause() != null) {
            str.append(" ON ");
            str.append(this.maybeParens(node.getJoinClause()));
        }
        if (node.getUsingClause() != null) {
            str.append(" USING (");
            str.append(this.toString(node.getUsingClause()));
            str.append(')');
        }
        return str.toString();
    }

    protected String unionNode(UnionNode node) throws StandardException {
        return this.toString(node.getLeftResultSet()) + " UNION " + this.toString(node.getRightResultSet());
    }

    protected String tableName(TableName node) throws StandardException {
        return node.getFullTableName();
    }

    protected String columnReference(ColumnReference node) throws StandardException {
        return node.getSQLColumnName();
    }

    protected String virtualColumnNode(VirtualColumnNode node) throws StandardException {
        return node.getSourceColumn().getName();
    }

    protected String groupByList(GroupByList node) throws StandardException {
        return "GROUP BY " + this.nodeList(node);
    }

    protected String groupByColumn(GroupByColumn node) throws StandardException {
        return this.maybeParens(node.getColumnExpression());
    }

    protected String orderByList(OrderByList node) throws StandardException {
        return "ORDER BY " + this.nodeList(node);
    }

    protected String orderByColumn(OrderByColumn node) throws StandardException {
        String result = this.maybeParens(node.getExpression());
        if (!node.isAscending()) {
            result = result + " DESC";
        }
        if (node.isNullsOrderedLow()) {
            result = result + " NULLS FIRST";
        }
        return result;
    }

    protected String partitionByList(PartitionByList node) throws StandardException {
        return "PARTITION BY " + this.nodeList(node);
    }

    protected String partitionByColumn(PartitionByColumn node) throws StandardException {
        return this.toString(node.getColumnExpression());
    }

    protected String windowList(WindowList node) throws StandardException {
        return "WINDOW " + this.nodeList(node);
    }

    protected String windowDefinitionNode(WindowDefinitionNode node) throws StandardException {
        StringBuffer str = new StringBuffer("");
        if (!node.isInline()) {
            str.append(node.getName());
            str.append(" AS ");
        }
        str.append("(");
        if (node.getPartitionByList() != null) {
            str.append(this.toString(node.getPartitionByList()));
        }
        if (node.getOrderByList() != null) {
            if (node.getPartitionByList() != null) {
                str.append(" ");
            }
            str.append(this.toString(node.getOrderByList()));
        }
        str.append(")");
        return str.toString();
    }

    protected String windowReferenceNode(WindowReferenceNode node) throws StandardException {
        return node.getName();
    }

    protected String aggregateWindowFunctionNode(AggregateWindowFunctionNode node) throws StandardException {
        return this.toString(node.getAggregateFunction()) + " OVER " + this.toString(node.getWindow());
    }

    protected String rowNumberFunctionNode(RowNumberFunctionNode node) throws StandardException {
        return node.getOperator().toUpperCase() + "()" + " OVER " + this.toString(node.getWindow());
    }

    protected String binaryLogicalOperatorNode(BinaryLogicalOperatorNode node) throws StandardException {
        return this.infixBinary(node);
    }

    protected String binaryComparisonOperatorNode(BinaryComparisonOperatorNode node) throws StandardException {
        return this.infixBinary(node);
    }

    protected String binaryArithmeticOperatorNode(BinaryArithmeticOperatorNode node) throws StandardException {
        return this.infixBinary(node);
    }

    protected String binaryBitOperatorNode(BinaryBitOperatorNode node) throws StandardException {
        return this.infixBinary(node);
    }

    protected String concatenationOperatorNode(ConcatenationOperatorNode node) throws StandardException {
        return this.infixBinary(node);
    }

    protected String leftRightFuncOperatorNode(LeftRightFuncOperatorNode node) throws StandardException {
        return this.functionBinary(node);
    }

    protected String simpleStringOperatorNode(SimpleStringOperatorNode node) throws StandardException {
        return this.functionUnary(node);
    }

    protected String notNode(NotNode node) throws StandardException {
        return this.prefixUnary(node);
    }

    protected String isNullNode(IsNullNode node) throws StandardException {
        return this.suffixUnary(node);
    }

    protected String unaryArithmeticOperatorNode(UnaryArithmeticOperatorNode node) throws StandardException {
        return this.functionUnary(node);
    }

    protected String unaryPrefixOperatorNode(UnaryArithmeticOperatorNode node) throws StandardException {
        return this.prefixUnary(node);
    }

    protected String unaryBitOperatorNode(UnaryBitOperatorNode node) throws StandardException {
        return this.prefixUnary(node);
    }

    protected String extractOperatorNode(ExtractOperatorNode node) throws StandardException {
        return node.getOperator().substring("EXTRACT ".length()).toUpperCase() + "(" + this.toString(node.getOperand()) + ")";
    }

    protected String unaryDateTimestampOperatorNode(UnaryDateTimestampOperatorNode node) throws StandardException {
        return this.functionUnary(node);
    }

    protected String timestampOperatorNode(TimestampOperatorNode node) throws StandardException {
        return this.functionBinary(node);
    }

    protected String lengthOperatorNode(LengthOperatorNode node) throws StandardException {
        return this.functionUnary(node);
    }

    protected String octetLengthOperatorNode(OctetLengthOperatorNode node) throws StandardException {
        return this.functionUnary(node);
    }

    protected String isNode(IsNode node) throws StandardException {
        ValueNode rightOperand;
        StringBuilder str = new StringBuilder(this.maybeParens(node.getLeftOperand()));
        str.append(" IS ");
        if (node.isNegated()) {
            str.append("NOT ");
        }
        if ((rightOperand = node.getRightOperand()) instanceof BooleanConstantNode) {
            Boolean value = (Boolean)((BooleanConstantNode)rightOperand).getValue();
            if (value == null) {
                str.append("UNKNOWN");
            } else {
                str.append(value.toString().toUpperCase());
            }
        } else {
            str.append(this.maybeParens(rightOperand));
        }
        return str.toString();
    }

    protected String aggregateNode(AggregateNode node) throws StandardException {
        if (node.getOperand() == null) {
            return node.getAggregateName();
        }
        return node.getAggregateName() + "(" + this.toString(node.getOperand()) + ")";
    }

    protected String likeEscapeOperatorNode(LikeEscapeOperatorNode node) throws StandardException {
        String like = this.maybeParens(node.getReceiver()) + " " + node.getOperator().toUpperCase() + " " + this.maybeParens(node.getLeftOperand());
        if (node.getRightOperand() != null) {
            like = like + " ESCAPE " + this.maybeParens(node.getRightOperand());
        }
        return like;
    }

    protected String ternaryOperatorNode(TernaryOperatorNode node) throws StandardException {
        StringBuilder str = new StringBuilder(node.getOperator().toUpperCase());
        str.append("(");
        str.append(this.toString(node.getReceiver()));
        str.append(", ");
        str.append(this.toString(node.getLeftOperand()));
        if (node.getRightOperand() != null) {
            str.append(", ");
            str.append(this.toString(node.getRightOperand()));
        }
        return str.toString();
    }

    protected String timestampFunctionNode(TernaryOperatorNode node) throws StandardException {
        String interval = this.toString(node.getReceiver());
        switch ((Integer)((ConstantNode)node.getReceiver()).getValue()) {
            case 0: {
                interval = "YEAR";
                break;
            }
            case 1: {
                interval = "QUARTER";
                break;
            }
            case 2: {
                interval = "MONTH";
                break;
            }
            case 3: {
                interval = "WEEK";
                break;
            }
            case 4: {
                interval = "DAY";
                break;
            }
            case 5: {
                interval = "HOUR";
                break;
            }
            case 6: {
                interval = "MINUTE";
                break;
            }
            case 7: {
                interval = "SECOND";
                break;
            }
            case 8: {
                interval = "MICROSECOND>";
            }
        }
        return node.getOperator().toUpperCase() + "(" + interval + ", " + this.toString(node.getLeftOperand()) + ", " + this.toString(node.getRightOperand()) + ")";
    }

    protected String trimOperatorNode(TrimOperatorNode node) throws StandardException {
        if (node.getRightOperand() instanceof ConstantNode && " ".equals(((ConstantNode)node.getRightOperand()).getValue())) {
            return node.getOperator().toUpperCase() + "(" + this.toString(node.getLeftOperand()) + ")";
        }
        StringBuilder str = new StringBuilder("TRIM(");
        if ("LTRIM".equals(node.getOperator())) {
            str.append("LEADING");
        } else if ("RTRIM".equals(node.getOperator())) {
            str.append("TRAILING");
        } else {
            str.append("BOTH");
        }
        str.append(" ");
        str.append(this.toString(node.getRightOperand()));
        str.append(" FROM ");
        str.append(this.toString(node.getLeftOperand()));
        return str.toString();
    }

    protected String inListOperatorNode(InListOperatorNode node) throws StandardException {
        return this.maybeParens(node.getLeftOperand()) + " " + (node.isNegated() ? "NOT IN" : "IN") + " (" + this.toString(node.getRightOperandList()) + ")";
    }

    protected String valueNodeList(ValueNodeList node) throws StandardException {
        return this.nodeList(node, true);
    }

    protected String betweenOperatorNode(BetweenOperatorNode node) throws StandardException {
        return this.maybeParens(node.getLeftOperand()) + " BETWEEN " + this.maybeParens((QueryTreeNode)node.getRightOperandList().get(0)) + " AND " + this.maybeParens((QueryTreeNode)node.getRightOperandList().get(1));
    }

    protected String conditionalNode(ConditionalNode node) throws StandardException {
        ValueNode elseNode;
        StringBuilder str = new StringBuilder("CASE");
        while (true) {
            str.append(" WHEN ");
            str.append(this.maybeParens(node.getTestCondition()));
            str.append(" THEN ");
            str.append(this.maybeParens(node.getThenNode()));
            elseNode = node.getElseNode();
            if (!(elseNode instanceof ConditionalNode)) break;
            node = (ConditionalNode)elseNode;
        }
        str.append(" ELSE ");
        str.append(this.maybeParens(elseNode));
        str.append(" END");
        return str.toString();
    }

    protected String simpleCaseNode(SimpleCaseNode node) throws StandardException {
        StringBuilder str = new StringBuilder("CASE ");
        str.append(this.maybeParens(node.getOperand()));
        for (int i = 0; i < node.getNumberOfCases(); ++i) {
            str.append(" WHEN ");
            str.append(this.maybeParens(node.getCaseOperand(i)));
            str.append(" THEN ");
            str.append(this.maybeParens(node.getResultValue(i)));
        }
        if (node.getElseValue() != null) {
            str.append(" ELSE ");
            str.append(this.maybeParens(node.getElseValue()));
        }
        str.append(" END");
        return str.toString();
    }

    protected String coalesceFunctionNode(CoalesceFunctionNode node) throws StandardException {
        return this.functionCall(node.getFunctionName(), node.getArgumentsList());
    }

    protected String constantNode(ConstantNode node) throws StandardException {
        Object value = node.getValue();
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String) {
            return "'" + ((String)value).replace("'", "''") + "'";
        }
        if (value instanceof byte[]) {
            return this.hexConstant((byte[])value);
        }
        if (value instanceof Double) {
            return String.format("%e", value);
        }
        if (value instanceof Boolean) {
            return value.toString().toUpperCase();
        }
        return value.toString();
    }

    protected String prefixUnary(UnaryOperatorNode node) throws StandardException {
        return node.getOperator().toUpperCase() + " " + this.maybeParens(node.getOperand());
    }

    protected String suffixUnary(UnaryOperatorNode node) throws StandardException {
        return this.maybeParens(node.getOperand()) + " " + node.getOperator().toUpperCase();
    }

    protected String functionUnary(UnaryOperatorNode node) throws StandardException {
        return node.getOperator().toUpperCase() + "(" + this.toString(node.getOperand()) + ")";
    }

    protected String infixBinary(BinaryOperatorNode node) throws StandardException {
        return this.maybeParens(node.getLeftOperand()) + " " + node.getOperator().toUpperCase() + " " + this.maybeParens(node.getRightOperand());
    }

    protected String functionBinary(BinaryOperatorNode node) throws StandardException {
        return node.getOperator().toUpperCase() + "(" + this.toString(node.getLeftOperand()) + ", " + this.toString(node.getRightOperand()) + ")";
    }

    protected String functionCall(String functionName, ValueNodeList args) throws StandardException {
        return functionName + "(" + this.nodeList(args, true) + ")";
    }

    protected String nodeList(QueryTreeNodeList<? extends QueryTreeNode> nl) throws StandardException {
        return this.nodeList(nl, false);
    }

    protected String nodeList(QueryTreeNodeList<? extends QueryTreeNode> nl, boolean expr) throws StandardException {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (QueryTreeNode queryTreeNode : nl) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(expr ? this.maybeParens(queryTreeNode) : this.toString(queryTreeNode));
        }
        return str.toString();
    }

    protected String maybeParens(QueryTreeNode node) throws StandardException {
        String str = this.toString(node);
        if (node instanceof ConstantNode) {
            return str;
        }
        if (str.indexOf(32) < 0) {
            return str;
        }
        return "(" + str + ")";
    }

    protected String hexConstant(byte[] value) {
        StringBuilder str = new StringBuilder("X'");
        for (byte b : value) {
            str.append(Integer.toString(b & 0xFF, 16).toUpperCase());
        }
        str.append("'");
        return str.toString();
    }

    protected String parameterNode(ParameterNode node) throws StandardException {
        return "$" + (node.getParameterNumber() + 1);
    }

    protected String currentDatetimeOperatorNode(CurrentDatetimeOperatorNode node) throws StandardException {
        switch (node.getField()) {
            case DATE: {
                return "CURRENT_DATE";
            }
            case TIME: {
                return "CURRENT_TIME";
            }
            case TIMESTAMP: {
                return "CURRENT_TIMESTAMP";
            }
        }
        return "**UNKNOWN(" + (Object)((Object)node.getField()) + ")**";
    }

    protected String castNode(CastNode node) throws StandardException {
        return "CAST(" + this.toString(node.getCastOperand()) + " AS " + node.getType().toString() + ")";
    }

    protected String explicitCollateNode(ExplicitCollateNode node) throws StandardException {
        return this.maybeParens(node.getOperand()) + " COLLATE " + node.getCollation();
    }

    protected String nextSequenceNode(NextSequenceNode node) throws StandardException {
        return "NEXT VALUE FOR " + this.toString(node.getSequenceName());
    }

    protected String currentSequenceNode(CurrentSequenceNode node) throws StandardException {
        return "CURRENT VALUE FOR " + this.toString(node.getSequenceName());
    }

    protected String javaToSQLValueNode(JavaToSQLValueNode node) throws StandardException {
        return this.toString(node.getJavaValueNode());
    }

    protected String sqlToJavaValueNode(SQLToJavaValueNode node) throws StandardException {
        return this.toString(node.getSQLValueNode());
    }

    protected String staticMethodCallNode(StaticMethodCallNode node) throws StandardException {
        StringBuilder str = new StringBuilder();
        if (node.getProcedureName() != null) {
            str.append(this.toString(node.getProcedureName()));
        } else {
            str.append(node.getMethodName());
        }
        str.append("(");
        JavaValueNode[] params = node.getMethodParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(this.maybeParens(params[i]));
        }
        str.append(")");
        return str.toString();
    }

    protected String callStatementNode(CallStatementNode node) throws StandardException {
        return "CALL " + this.javaToSQLValueNode(node.methodCall());
    }

    protected String qualifiedDDLNode(DDLStatementNode node) throws StandardException {
        return node.statementToString() + " " + node.getObjectName();
    }

    protected String explainStatementNode(ExplainStatementNode node) throws StandardException {
        String detail;
        switch (node.getDetail()) {
            case BRIEF: {
                detail = "BRIEF ";
                break;
            }
            case VERBOSE: {
                detail = "VERBOSE ";
                break;
            }
            default: {
                detail = "";
            }
        }
        return "EXPLAIN " + detail + this.toString(node.getStatement());
    }

    protected String transactionControlNode(TransactionControlNode node) throws StandardException {
        return node.statementToString();
    }

    protected String setTransactionIsolationNode(SetTransactionIsolationNode node) throws StandardException {
        return node.statementToString() + " " + node.getIsolationLevel().getSyntax();
    }

    protected String setTransactionAccessNode(SetTransactionAccessNode node) throws StandardException {
        return node.statementToString() + " " + node.getAccessMode().getSyntax();
    }

    protected String setConfigurationNode(SetConfigurationNode node) throws StandardException {
        return node.statementToString() + " = '" + node.getValue() + "'";
    }

    protected String rowCtorNode(RowConstructorNode row) throws StandardException {
        ValueNodeList list = row.getNodeList();
        switch (list.size()) {
            case 0: {
                return "EMPTY";
            }
            case 1: {
                Object node = list.get(0);
                if (node instanceof RowConstructorNode) break;
                return this.toString((QueryTreeNode)node);
            }
        }
        StringBuilder bd = new StringBuilder();
        for (ValueNode node : list) {
            this.doPrint(node, bd);
            bd.append(", ");
        }
        return bd.substring(0, bd.length() - 2);
    }

    protected String declareStatementNode(DeclareStatementNode node) throws StandardException {
        return "DECLARE " + node.getName() + " CURSOR FOR " + this.toString(node.getStatement());
    }

    protected String fetchStatementNode(FetchStatementNode node) throws StandardException {
        return "FETCH " + (node.getCount() < 0 ? "ALL" : Integer.toString(node.getCount())) + " FROM " + node.getName();
    }

    protected String closeStatementNode(CloseStatementNode node) throws StandardException {
        return "CLOSE " + node.getName();
    }

    protected String prepareStatementNode(PrepareStatementNode node) throws StandardException {
        return "PREPARE " + node.getName() + " AS " + this.toString(node.getStatement());
    }

    protected String executeStatementNode(ExecuteStatementNode node) throws StandardException {
        return "EXECUTE " + node.getName() + "(" + this.nodeList(node.getParameterList(), true) + ")";
    }

    protected String deallocateStatementNode(DeallocateStatementNode node) throws StandardException {
        return "DEALLOCATE " + node.getName();
    }

    protected String copyStatementNode(CopyStatementNode node) throws StandardException {
        StringBuilder str = new StringBuilder("COPY ");
        if (node.getSubquery() != null) {
            str.append("(");
            str.append(this.toString(node.getSubquery()));
            str.append(")");
        } else {
            str.append(node.getTableName());
            if (node.getColumnList() != null) {
                str.append("(");
                str.append(this.toString(node.getColumnList()));
                str.append(")");
            }
        }
        switch (node.getMode()) {
            case FROM_TABLE: 
            case FROM_SUBQUERY: {
                str.append(" TO ");
                break;
            }
            case TO_TABLE: {
                str.append(" FROM ");
            }
        }
        if (node.getFilename() != null) {
            str.append("'");
            str.append(node.getFilename());
            str.append("'");
        } else if (node.getMode() == CopyStatementNode.Mode.TO_TABLE) {
            str.append("STDIN");
        } else {
            str.append("STDOUT");
        }
        boolean options = false;
        if (node.getFormat() != null) {
            options = this.copyOption(str, "FORMAT", node.getFormat().name(), options);
        }
        if (node.getDelimiter() != null) {
            options = this.copyOptionString(str, "DELIMITER", node.getDelimiter(), options);
        }
        if (node.getNullString() != null) {
            options = this.copyOptionString(str, "NULL", node.getNullString(), options);
        }
        if (node.isHeader()) {
            options = this.copyOption(str, "HEADER", "TRUE", options);
        }
        if (node.getQuote() != null) {
            options = this.copyOptionString(str, "QUOTE", node.getQuote(), options);
        }
        if (node.getEscape() != null) {
            options = this.copyOptionString(str, "ESCAPE", node.getEscape(), options);
        }
        if (node.getEncoding() != null) {
            options = this.copyOptionString(str, "ENCODING", node.getEncoding(), options);
        }
        if (node.getCommitFrequency() != 0L) {
            options = this.copyOption(str, "COMMIT", node.getCommitFrequency() + " ROWS", options);
        }
        if (options) {
            str.append(")");
        }
        return str.toString();
    }

    protected boolean copyOptionString(StringBuilder str, String keyword, String value, boolean options) {
        return this.copyOption(str, keyword, "'" + value + "'", options);
    }

    protected boolean copyOption(StringBuilder str, String keyword, String value, boolean options) {
        if (!options) {
            str.append(" WITH (");
        } else {
            str.append(", ");
        }
        str.append(keyword);
        str.append(" ");
        str.append(value);
        return true;
    }

    protected void doPrint(QueryTreeNode node, StringBuilder bd) throws StandardException {
        if (node instanceof RowConstructorNode) {
            bd.append(this.rowCtorNode((RowConstructorNode)node));
        } else {
            bd.append(this.toString(node));
        }
    }

    protected String groupConcat(GroupConcatNode node) throws StandardException {
        StringBuilder ret = new StringBuilder("GROUP_CONCAT(");
        ret.append(node.getOperand());
        OrderByList orderBy = node.getOrderBy();
        if (orderBy != null) {
            ret.append(this.toString(orderBy));
        }
        ret.append("SEPARATOR '").append(node.getSeparator()).append("')");
        return ret.toString();
    }
}

