/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class UnaryOperatorNode
extends ValueNode {
    protected String operator;
    protected String methodName;
    protected String resultInterfaceType;
    protected String receiverInterfaceType;
    ValueNode operand;

    @Override
    public void init(Object operand, Object operatorOrOpType, Object methodNameOrAddedArgs) throws StandardException {
        this.operand = (ValueNode)operand;
        this.operator = (String)operatorOrOpType;
        this.methodName = (String)methodNameOrAddedArgs;
    }

    @Override
    public void init(Object operand) throws StandardException {
        this.operand = (ValueNode)operand;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        UnaryOperatorNode other = (UnaryOperatorNode)node;
        this.operator = other.operator;
        this.methodName = other.methodName;
        this.resultInterfaceType = other.resultInterfaceType;
        this.receiverInterfaceType = other.receiverInterfaceType;
        this.operand = (ValueNode)this.getNodeFactory().copyNode(other.operand, this.getParserContext());
    }

    void setOperator(String operator2) {
        this.operator = operator2;
    }

    public String getOperator() {
        return this.operator;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.operand != null) {
            this.printLabel(depth, "operand: ");
            this.operand.treePrint(depth + 1);
        }
    }

    public ValueNode getOperand() {
        return this.operand;
    }

    public void setOperand(ValueNode operand) {
        this.operand = operand;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.operand != null) {
            this.operand = (ValueNode)this.operand.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            UnaryOperatorNode other = (UnaryOperatorNode)o;
            return this.operator.equals(other.operator) && (this.operand == other.operand || this.operand != null && this.operand.isEquivalent(other.operand));
        }
        return false;
    }
}

