/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.FromList;
import com.akiban.sql.parser.GroupByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.parser.WindowList;

public class SelectNode
extends ResultSetNode {
    private FromList fromList;
    private ValueNode whereClause;
    private GroupByList groupByList;
    private WindowList windows;
    private boolean isDistinct;
    private boolean isStraightJoin;
    private ValueNode havingClause;

    @Override
    public void init(Object selectList, Object aggregateList, Object fromList, Object whereClause, Object groupByList, Object havingClause, Object windowDefinitionList) throws StandardException {
        this.resultColumns = (ResultColumnList)selectList;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
        this.fromList = (FromList)fromList;
        this.whereClause = (ValueNode)whereClause;
        this.groupByList = (GroupByList)groupByList;
        this.havingClause = (ValueNode)havingClause;
        this.windows = (WindowList)windowDefinitionList;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        SelectNode other = (SelectNode)node;
        this.fromList = (FromList)this.getNodeFactory().copyNode(other.fromList, this.getParserContext());
        this.whereClause = (ValueNode)this.getNodeFactory().copyNode(other.whereClause, this.getParserContext());
        this.groupByList = (GroupByList)this.getNodeFactory().copyNode(other.groupByList, this.getParserContext());
        this.windows = (WindowList)this.getNodeFactory().copyNode(other.windows, this.getParserContext());
        this.isDistinct = other.isDistinct;
        this.havingClause = (ValueNode)this.getNodeFactory().copyNode(other.havingClause, this.getParserContext());
    }

    @Override
    public String toString() {
        return "isDistinct: " + this.isDistinct + "\n" + super.toString();
    }

    public String statementToString() {
        return "SELECT";
    }

    public void makeDistinct() {
        this.isDistinct = true;
    }

    public void clearDistinct() {
        this.isDistinct = false;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void makeStraightJoin() {
        this.isStraightJoin = true;
    }

    public boolean isStraightJoin() {
        return this.isStraightJoin;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "fromList: ");
        if (this.fromList != null) {
            this.fromList.treePrint(depth + 1);
        }
        if (this.whereClause != null) {
            this.printLabel(depth, "whereClause: ");
            this.whereClause.treePrint(depth + 1);
        }
        if (this.groupByList != null) {
            this.printLabel(depth, "groupByList:");
            this.groupByList.treePrint(depth + 1);
        }
        if (this.havingClause != null) {
            this.printLabel(depth, "havingClause:");
            this.havingClause.treePrint(depth + 1);
        }
        if (this.windows != null) {
            this.printLabel(depth, "windows: ");
            this.windows.treePrint(depth + 1);
        }
    }

    public FromList getFromList() {
        return this.fromList;
    }

    public ValueNode getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(ValueNode whereClause) {
        this.whereClause = whereClause;
    }

    public GroupByList getGroupByList() {
        return this.groupByList;
    }

    public ValueNode getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(ValueNode havingClause) {
        this.havingClause = havingClause;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.fromList != null) {
            this.fromList = (FromList)this.fromList.accept(v);
        }
        if (this.whereClause != null) {
            this.whereClause = (ValueNode)this.whereClause.accept(v);
        }
        if (this.groupByList != null) {
            this.groupByList = (GroupByList)this.groupByList.accept(v);
        }
        if (this.havingClause != null) {
            this.havingClause = (ValueNode)this.havingClause.accept(v);
        }
        if (this.windows != null) {
            this.windows = (WindowList)this.windows.accept(v);
        }
    }

    public boolean hasWindows() {
        return this.windows != null;
    }

    public WindowList getWindows() {
        return this.windows;
    }
}

