/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.Visitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class QueryTreeNodeList<N extends QueryTreeNode>
extends QueryTreeNode
implements Iterable<N> {
    private List<N> list = new ArrayList<N>();

    public final int size() {
        return this.list.size();
    }

    protected List<N> getList() {
        return this.list;
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public N get(int index) {
        return (N)((QueryTreeNode)this.list.get(index));
    }

    public void add(N n) {
        this.list.add(n);
    }

    public final N remove(int index) {
        return (N)((QueryTreeNode)this.list.remove(index));
    }

    public final void remove(N n) {
        this.list.remove(n);
    }

    public final int indexOf(N n) {
        return this.list.indexOf(n);
    }

    public final void set(int index, N n) {
        this.list.set(index, n);
    }

    public final void add(int index, N n) {
        this.list.add(index, n);
    }

    public final void addAll(QueryTreeNodeList<N> other) {
        this.list.addAll(other.list);
    }

    public final void clear() {
        this.list.clear();
    }

    @Override
    public final Iterator<N> iterator() {
        return this.list.iterator();
    }

    public final void destructiveAddAll(QueryTreeNodeList<N> other) {
        this.addAll(other);
        other.clear();
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        QueryTreeNodeList other = (QueryTreeNodeList)node;
        for (QueryTreeNode n : other.list) {
            this.list.add(this.getNodeFactory().copyNode(n, this.getParserContext()));
        }
    }

    @Override
    public void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            QueryTreeNodeList.debugPrint(QueryTreeNodeList.formatNodeString("[" + index + "]:", depth));
            N elt = this.get(index);
            ((QueryTreeNode)elt).treePrint(depth);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            this.set(index, (QueryTreeNode)((QueryTreeNode)this.get(index)).accept(v));
        }
    }
}

