/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.JavaValueNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.SQLToJavaValueNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import java.util.List;

public abstract class MethodCallNode
extends JavaValueNode {
    protected String methodName;
    protected String javaClassName;
    protected JavaValueNode[] methodParms;

    @Override
    public void init(Object methodName) {
        this.methodName = (String)methodName;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        MethodCallNode other = (MethodCallNode)node;
        this.methodName = other.methodName;
        this.javaClassName = other.javaClassName;
        if (other.methodParms != null) {
            this.methodParms = new JavaValueNode[other.methodParms.length];
            for (int i = 0; i < this.methodParms.length; ++i) {
                this.methodParms[i] = (JavaValueNode)this.getNodeFactory().copyNode(other.methodParms[i], this.getParserContext());
            }
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public JavaValueNode[] getMethodParameters() {
        return this.methodParms;
    }

    public void addParms(List<ValueNode> parameterList) throws StandardException {
        this.methodParms = new JavaValueNode[parameterList.size()];
        int plSize = parameterList.size();
        for (int index = 0; index < plSize; ++index) {
            QueryTreeNode qt = parameterList.get(index);
            if (!(qt instanceof JavaValueNode)) {
                qt = (SQLToJavaValueNode)this.getNodeFactory().getNode(28, qt, this.getParserContext());
            }
            this.methodParms[index] = (JavaValueNode)qt;
        }
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodParms != null) {
            for (int parm = 0; parm < this.methodParms.length; ++parm) {
                if (this.methodParms[parm] == null) continue;
                this.printLabel(depth, "methodParms[" + parm + "] :");
                this.methodParms[parm].treePrint(depth + 1);
            }
        }
    }

    @Override
    public String toString() {
        return "methodName: " + (this.methodName != null ? this.methodName : "null") + "\n" + super.toString();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        for (int parm = 0; !v.stopTraversal() && parm < this.methodParms.length; ++parm) {
            if (this.methodParms[parm] == null) continue;
            this.methodParms[parm] = (JavaValueNode)this.methodParms[parm].accept(v);
        }
    }
}

