/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitor;

public final class InListOperatorNode
extends ValueNode {
    protected RowConstructorNode leftOperand;
    protected RowConstructorNode rightOperandList;
    protected boolean negated;

    @Override
    public void init(Object leftOperand, Object rightOperandList) throws StandardException {
        if (leftOperand instanceof RowConstructorNode) {
            this.leftOperand = (RowConstructorNode)leftOperand;
        } else {
            ValueNodeList list = (ValueNodeList)this.getNodeFactory().getNode(15, this.getParserContext());
            list.addValueNode((ValueNode)leftOperand);
            this.leftOperand = (RowConstructorNode)this.getNodeFactory().getNode(166, list, new int[]{0}, this.getParserContext());
        }
        this.rightOperandList = (RowConstructorNode)rightOperandList;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        InListOperatorNode other = (InListOperatorNode)node;
        this.leftOperand = (RowConstructorNode)this.getNodeFactory().copyNode(other.leftOperand, this.getParserContext());
        this.rightOperandList = (RowConstructorNode)this.getNodeFactory().copyNode(other.rightOperandList, this.getParserContext());
    }

    @Override
    public String toString() {
        return "operator: " + (this.negated ? "NOT " : "") + "IN\n" + "methodName: in\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperandList != null) {
            this.printLabel(depth, "rightOperandList: ");
            this.rightOperandList.treePrint(depth + 1);
        }
    }

    public void setLeftOperand(RowConstructorNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public RowConstructorNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperandList(RowConstructorNode newRightOperandList) {
        this.rightOperandList = newRightOperandList;
    }

    public RowConstructorNode getRightOperandList() {
        return this.rightOperandList;
    }

    @Override
    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftOperand != null) {
            this.leftOperand = (RowConstructorNode)this.leftOperand.accept(v);
        }
        if (this.rightOperandList != null) {
            this.rightOperandList = (RowConstructorNode)this.rightOperandList.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        InListOperatorNode other = (InListOperatorNode)o;
        return this.leftOperand.isEquivalent(other.getLeftOperand()) && this.rightOperandList.isEquivalent(other.rightOperandList);
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }
}

