/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.ExistenceCheck;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;

public class DropSequenceNode
extends DDLStatementNode {
    private TableName dropItem;
    private ExistenceCheck existenceCheck;
    private int dropBehavior;

    @Override
    public void init(Object dropSequenceName, Object dropBehavior, Object ec) throws StandardException {
        this.dropItem = (TableName)dropSequenceName;
        this.initAndCheck(this.dropItem);
        this.dropBehavior = (Integer)dropBehavior;
        this.existenceCheck = (ExistenceCheck)((Object)ec);
    }

    public int getDropBehavior() {
        return this.dropBehavior;
    }

    public ExistenceCheck getExistenceCheck() {
        return this.existenceCheck;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        DropSequenceNode other = (DropSequenceNode)node;
        this.dropBehavior = other.dropBehavior;
        this.existenceCheck = other.existenceCheck;
        this.dropItem = (TableName)this.getNodeFactory().copyNode(other.dropItem, this.getParserContext());
    }

    @Override
    public String statementToString() {
        return "DROP SEQUENCE ".concat(this.dropItem.getTableName());
    }

    @Override
    public String toString() {
        return super.toString() + "dropBehavior: " + this.dropBehavior + "\n" + "existenceCheck: " + (Object)((Object)this.existenceCheck) + "\n";
    }
}

