/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.TableElementNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.ValueNode;
import java.util.Properties;

public class ConstraintDefinitionNode
extends TableElementNode {
    protected TableName constraintName;
    protected ConstraintType constraintType;
    protected Properties properties;
    private ResultColumnList columnList;
    private String constraintText;
    private ValueNode checkCondition;
    private int behavior;
    private ConstraintType verifyType = ConstraintType.DROP;

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText, Object behavior) {
        this.constraintName = (TableName)constraintName;
        super.init(null);
        if (this.constraintName != null) {
            this.name = this.constraintName.getTableName();
        }
        this.constraintType = (ConstraintType)((Object)constraintType);
        this.properties = (Properties)properties;
        this.columnList = (ResultColumnList)rcl;
        this.checkCondition = (ValueNode)checkCondition;
        this.constraintText = (String)constraintText;
        this.behavior = (Integer)behavior;
    }

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText) {
        this.init(constraintName, constraintType, rcl, properties, checkCondition, constraintText, 2);
    }

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText, Object behavior, Object verifyType) {
        this.init(constraintName, constraintType, rcl, properties, checkCondition, constraintText, behavior);
        this.verifyType = (ConstraintType)((Object)verifyType);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        ConstraintDefinitionNode other = (ConstraintDefinitionNode)node;
        this.constraintName = (TableName)this.getNodeFactory().copyNode(other.constraintName, this.getParserContext());
        this.constraintType = other.constraintType;
        this.properties = other.properties;
        this.columnList = (ResultColumnList)this.getNodeFactory().copyNode(other.columnList, this.getParserContext());
        this.constraintText = other.constraintText;
        this.checkCondition = (ValueNode)this.getNodeFactory().copyNode(other.checkCondition, this.getParserContext());
        this.behavior = other.behavior;
        this.verifyType = other.verifyType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public ConstraintType getVerifyType() {
        return this.verifyType;
    }

    public ResultColumnList getColumnList() {
        return this.columnList;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "constraintName: " + (this.constraintName != null ? this.constraintName.toString() : "null") + "\n" + "constraintType: " + (Object)((Object)this.constraintType) + "\n" + (this.constraintType == ConstraintType.DROP ? "verifyType: " + (Object)((Object)this.verifyType) + "\n" : "") + "properties: " + (this.properties != null ? this.properties.toString() : "null") + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.columnList != null) {
            this.printLabel(depth, "columnList: ");
            this.columnList.treePrint(depth + 1);
        }
    }

    public static enum ConstraintType {
        NOT_NULL,
        PRIMARY_KEY,
        UNIQUE,
        CHECK,
        DROP,
        FOREIGN_KEY,
        INDEX;

    }
}

