/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.types.TypeId;

public class BitConstantNode
extends ConstantNode {
    private int bitLength;

    @Override
    public void init(Object arg1) throws StandardException {
        super.init(arg1, Boolean.TRUE, 0);
    }

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        String a1 = (String)arg1;
        byte[] nv = BitConstantNode.fromHexString(a1, 0, a1.length());
        Integer bitLengthO = (Integer)arg2;
        this.bitLength = bitLengthO;
        this.init(TypeId.getBuiltInTypeId(-2), Boolean.FALSE, bitLengthO);
        this.setValue(nv);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BitConstantNode other = (BitConstantNode)node;
        this.bitLength = other.bitLength;
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        if (length % 2 != 0) {
            return null;
        }
        byte[] byteArray = new byte[length / 2];
        int j = 0;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            int high_nibble = Character.digit(s.charAt(i), 16);
            int low_nibble = Character.digit(s.charAt(i + 1), 16);
            if (high_nibble == -1 || low_nibble == -1) {
                return null;
            }
            byteArray[j++] = (byte)(high_nibble << 4 & 0xF0 | low_nibble & 0xF);
        }
        return byteArray;
    }
}

