/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class BinaryOperatorNode
extends ValueNode {
    protected String operator;
    protected String methodName;
    protected ValueNode leftOperand;
    protected ValueNode rightOperand;
    protected String leftInterfaceType;
    protected String rightInterfaceType;
    protected String resultInterfaceType;

    @Override
    public void init(Object leftOperand, Object rightOperand, Object operator2, Object methodName, Object leftInterfaceType, Object rightInterfaceType) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.operator = (String)operator2;
        this.methodName = (String)methodName;
        this.leftInterfaceType = (String)leftInterfaceType;
        this.rightInterfaceType = (String)rightInterfaceType;
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object leftInterfaceType, Object rightInterfaceType) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.leftInterfaceType = (String)leftInterfaceType;
        this.rightInterfaceType = (String)rightInterfaceType;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BinaryOperatorNode other = (BinaryOperatorNode)node;
        this.operator = other.operator;
        this.methodName = other.methodName;
        this.leftOperand = (ValueNode)this.getNodeFactory().copyNode(other.leftOperand, this.getParserContext());
        this.rightOperand = (ValueNode)this.getNodeFactory().copyNode(other.rightOperand, this.getParserContext());
        this.leftInterfaceType = other.leftInterfaceType;
        this.rightInterfaceType = other.rightInterfaceType;
        this.resultInterfaceType = other.resultInterfaceType;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    void setOperator(String operator2) {
        this.operator = operator2;
    }

    public String getOperator() {
        return this.operator;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setLeftRightInterfaceType(String iType) {
        this.leftInterfaceType = iType;
        this.rightInterfaceType = iType;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        BinaryOperatorNode other = (BinaryOperatorNode)o;
        return this.methodName.equals(other.methodName) && this.leftOperand.isEquivalent(other.leftOperand) && this.rightOperand.isEquivalent(other.rightOperand);
    }

    public static enum OperatorType {
        PLUS,
        MINUS,
        TIMES,
        DIVIDE,
        CONCATENATE,
        MOD,
        DIV,
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        AND,
        OR,
        LIKE,
        LTRIM,
        TRIM,
        RTRIM,
        BITAND,
        BITOR,
        BITXOR,
        LEFT_SHIFT,
        RIGHT_SHIFT,
        LEFT,
        RIGHT;

    }
}

