/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.types.DataTypeDescriptor;

public class BaseColumnNode
extends ValueNode {
    private String columnName;
    private TableName tableName;

    @Override
    public void init(Object columnName, Object tableName, Object type) throws StandardException {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.setType((DataTypeDescriptor)type);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BaseColumnNode other = (BaseColumnNode)node;
        this.columnName = other.columnName;
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + super.toString();
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    @Override
    public String getSchemaName() throws StandardException {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            BaseColumnNode other = (BaseColumnNode)o;
            return other.tableName.equals(this.tableName) && other.columnName.equals(this.columnName);
        }
        return false;
    }
}

