/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.FileNamer;
import com.codeborne.selenide.webdriver.DriverFactory;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriverFactory
implements DriverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractDriverFactory.class);
    private static final Pattern REGEX_SIGNED_INTEGER = Pattern.compile("^-?\\d+$");
    private static final Pattern REGEX_VERSION = Pattern.compile("(\\d+)(\\..*)?");
    private final FileNamer fileNamer = new FileNamer();

    protected File webdriverLog(Config config) {
        File logFolder = FileHelper.ensureFolderExists(new File(config.reportsFolder()).getAbsoluteFile());
        String logFileName = String.format("webdriver.%s.log", this.fileNamer.generateFileName());
        File logFile = new File(logFolder, logFileName).getAbsoluteFile();
        log.info("Write webdriver logs to: {}", (Object)logFile);
        return logFile;
    }

    protected <DS extends DriverService, B extends DriverService.Builder<DS, ?>> DS withLog(Config config, B dsBuilder) {
        if (config.webdriverLogsEnabled()) {
            dsBuilder.withLogFile(this.webdriverLog(config));
        }
        return (DS)dsBuilder.build();
    }

    protected MutableCapabilities createCommonCapabilities(Config config, Browser browser, @Nullable Proxy proxy) {
        return this.createCommonCapabilities(new MutableCapabilities(), config, browser, proxy);
    }

    protected <T extends MutableCapabilities> T createCommonCapabilities(T capabilities, Config config, Browser browser, @Nullable Proxy proxy) {
        String browserVersion;
        if (proxy != null) {
            capabilities.setCapability("proxy", (Object)proxy);
        }
        if ((browserVersion = config.browserVersion()) != null && !browserVersion.isEmpty()) {
            capabilities.setCapability("browserVersion", browserVersion);
        }
        capabilities.setCapability("pageLoadStrategy", config.pageLoadStrategy());
        if (browser.supportsInsecureCerts()) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        capabilities.setCapability("unhandledPromptBehavior", (Object)UnexpectedAlertBehaviour.ACCEPT);
        this.transferCapabilitiesFromSystemProperties(capabilities);
        return this.merge(capabilities, config.browserCapabilities());
    }

    protected <T extends MutableCapabilities> T merge(T capabilities, MutableCapabilities additionalCapabilities) {
        this.verifyItsSameBrowser((Capabilities)capabilities, (Capabilities)additionalCapabilities);
        return (T)capabilities.merge((Capabilities)additionalCapabilities);
    }

    private void verifyItsSameBrowser(Capabilities base, Capabilities extra) {
        if (this.areDifferent(base.getBrowserName(), extra.getBrowserName())) {
            throw new IllegalArgumentException(String.format("Conflicting browser name: '%s' vs. '%s'", base.getBrowserName(), extra.getBrowserName()));
        }
    }

    private boolean areDifferent(String text1, String text2) {
        return !text1.isEmpty() && !text2.isEmpty() && !text1.equals(text2);
    }

    protected void transferCapabilitiesFromSystemProperties(MutableCapabilities currentBrowserCapabilities) {
        String prefix = "capabilities.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.debug("Use {}={}", (Object)key, (Object)value);
            currentBrowserCapabilities.setCapability(capability, this.convertStringToNearestObjectType(value));
        }
    }

    protected Object convertStringToNearestObjectType(String value) {
        if (this.isBoolean(value)) {
            return Boolean.valueOf(value);
        }
        if (this.isInteger(value)) {
            return Integer.parseInt(value);
        }
        return value;
    }

    protected boolean isInteger(String value) {
        return REGEX_SIGNED_INTEGER.matcher(value).matches();
    }

    protected boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    protected int majorVersion(@Nullable String browserVersion) {
        if (StringUtils.isBlank((CharSequence)browserVersion)) {
            return 0;
        }
        Matcher matcher = REGEX_VERSION.matcher(browserVersion);
        return matcher.matches() ? Integer.parseInt(matcher.replaceFirst("$1")) : 0;
    }

    protected <T> T cast(Object value) {
        return (T)value;
    }
}

